/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.validation;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.stereotypeApplicationWithVSL.ExpressionValueRule;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.stereotypeApplicationWithVSL.StereotypeApplicationRule;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.stereotypeApplicationWithVSL.StereotypeApplicationWithVSLPackage;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.stereotypeApplicationWithVSL.TagSpecificationRule;
import org.eclipse.papyrus.marte.textedit.stereotypeapplicationwithvsl.xtext.validation.AbstractStereotypeApplicationWithVSLJavaValidator;
import org.eclipse.papyrus.marte.vsl.extensions.VSLContextUtil;
import org.eclipse.papyrus.marte.vsl.vSL.CollectionOrTuple;
import org.eclipse.papyrus.marte.vsl.vSL.Expression;
import org.eclipse.papyrus.marte.vsl.validation.VSLJavaValidator;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.validation.Check;

public class StereotypeApplicationWithVSLJavaValidator
extends AbstractStereotypeApplicationWithVSLJavaValidator {
    private static boolean valid_Stereotype = true;
    private static boolean valid_Expression = true;

    public static boolean validate() {
        return valid_Stereotype && valid_Expression;
    }

    @Check
    public void checkStereotypeApplicationRule_Stereotype(StereotypeApplicationRule stereotypeApplicationRule) {
        Stereotype appliedStereotype = stereotypeApplicationRule.getStereotype();
        valid_Stereotype = true;
        if (appliedStereotype != null) {
            ArrayList<Property> mandatoryProperties = new ArrayList<Property>();
            for (Property p : appliedStereotype.getAllAttributes()) {
                if (p.getLower() <= 0 || p.getName().startsWith("base_") || p.isDerived() || p.getDefaultValue() == null) continue;
                mandatoryProperties.add(p);
            }
            if (mandatoryProperties.isEmpty()) {
                valid_Stereotype = true;
                return;
            }
            ArrayList<Property> actuallySpecifiedProperties = new ArrayList<Property>();
            for (TagSpecificationRule tagSpec : stereotypeApplicationRule.getTagSpecification()) {
                actuallySpecifiedProperties.add(tagSpec.getProperty());
            }
            ArrayList<String> missingPropertyNames = new ArrayList<String>();
            for (Property mandatoryProperty : mandatoryProperties) {
                if (actuallySpecifiedProperties.contains(mandatoryProperty)) continue;
                missingPropertyNames.add(mandatoryProperty.getName());
            }
            if (missingPropertyNames.isEmpty()) {
                valid_Stereotype = true;
                return;
            }
            valid_Stereotype = false;
            String errorMessage = String.valueOf(missingPropertyNames.size() > 1 ? "Properties " : "Property ") + (String)missingPropertyNames.get(0);
            int i = 1;
            while (i < missingPropertyNames.size()) {
                errorMessage = String.valueOf(errorMessage) + ", " + (String)missingPropertyNames.get(i);
                ++i;
            }
            errorMessage = String.valueOf(errorMessage) + (missingPropertyNames.size() > 1 ? " are " : " is ") + " not optional.";
            this.error(errorMessage, stereotypeApplicationRule, (EStructuralFeature)StereotypeApplicationWithVSLPackage.eINSTANCE.getStereotypeApplicationRule_Stereotype(), -1);
        }
    }

    @Check
    public void checkExpressionValueRule_Expression(ExpressionValueRule expressionValueRule) {
        valid_Expression = true;
        if (expressionValueRule != null && expressionValueRule.getExpression() != null) {
            Property valuedProperty = ((TagSpecificationRule)expressionValueRule.eContainer()).getProperty();
            if (valuedProperty == null) {
                valid_Expression = true;
                return;
            }
            VSLJavaValidator.setExpectedType((Type)valuedProperty.getType());
            VSLJavaValidator.VSLValidationResult validationResult = VSLJavaValidator.eInstance.checkExpressionRule(expressionValueRule.getExpression());
            if (!validationResult.errorFound()) {
                String message;
                Type inferedType = validationResult.inferedType();
                if (VSLContextUtil.isAChoiceType((Classifier)((Classifier)valuedProperty.getType()))) {
                    boolean found = false;
                    for (NamedElement n : VSLContextUtil.getChoiceAttribs((Classifier)((Classifier)valuedProperty.getType()))) {
                        Property p = (Property)n;
                        if (p.getType() != inferedType && !((Classifier)inferedType).getGenerals().contains((Object)p.getType())) continue;
                        found = true;
                    }
                    if (!found) {
                        message = inferedType == null ? "Could not infer type of expression. " : "Found an expression of type " + inferedType.getName() + ". ";
                        message = String.valueOf(message) + "Expecting an expression of type " + valuedProperty.getType().getName();
                        this.error(message, (EStructuralFeature)StereotypeApplicationWithVSLPackage.eINSTANCE.getExpressionValueRule_Expression());
                        valid_Expression = false;
                    } else {
                        valid_Expression = true;
                    }
                } else if (VSLContextUtil.isAnIntervalType((Classifier)((Classifier)valuedProperty.getType()))) {
                    boolean found = false;
                    Property p = (Property)VSLContextUtil.getIntervalAttrib((Classifier)((Classifier)valuedProperty.getType()));
                    if (p.getType() == inferedType || ((Classifier)inferedType).getGenerals().contains((Object)p.getType())) {
                        found = true;
                    }
                    if (!found) {
                        String message2 = inferedType == null ? "Could not infer type of expression. " : "Found an expression of type " + inferedType.getName() + ". ";
                        message2 = String.valueOf(message2) + "Expecting an expression of type " + valuedProperty.getType().getName();
                        this.error(message2, (EStructuralFeature)StereotypeApplicationWithVSLPackage.eINSTANCE.getExpressionValueRule_Expression());
                        valid_Expression = false;
                    } else {
                        valid_Expression = true;
                    }
                } else if (inferedType != valuedProperty.getType()) {
                    if (!(valuedProperty.getType().getName().equals(inferedType.getName()) && (valuedProperty.getType().getName().equals("String") || valuedProperty.getType().getName().equals("Integer") || valuedProperty.getType().getName().equals("UnlimitedNatural") || valuedProperty.getType().getName().equals("Boolean")))) {
                        String message3 = inferedType == null ? "Could not infer type of expression. " : "Found an expression of type " + inferedType.getName() + ". ";
                        message3 = String.valueOf(message3) + "Expecting an expression of type " + valuedProperty.getType().getName();
                        this.error(message3, (EStructuralFeature)StereotypeApplicationWithVSLPackage.eINSTANCE.getExpressionValueRule_Expression());
                        valid_Expression = false;
                    } else {
                        valid_Expression = true;
                    }
                }
                if (valuedProperty.getUpper() > 1 || valuedProperty.getUpper() == -1) {
                    CollectionOrTuple cddColl = VSLJavaValidator.isACollection((Expression)expressionValueRule.getExpression());
                    boolean errorFound = false;
                    int cardinality = 1;
                    if (cddColl == null) {
                        errorFound = true;
                    } else {
                        cardinality = cddColl.getListOfValues() != null ? cddColl.getListOfValues().getValues().size() : 0;
                        boolean bl = errorFound = cardinality < valuedProperty.getLower();
                        if (!errorFound && valuedProperty.getUpper() != -1) {
                            boolean bl2 = errorFound = cardinality > valuedProperty.getUpper();
                        }
                    }
                    if (errorFound) {
                        String message4 = "The multiplicity of property " + valuedProperty.getName() + " is [" + valuedProperty.getLower() + ".." + (valuedProperty.getUpper() == -1 ? "*" : Integer.valueOf(valuedProperty.getUpper())) + "]. ";
                        message4 = cddColl != null ? String.valueOf(message4) + "The expression doest not match the expected multiplicity (cardinality = " + cardinality + ")." : String.valueOf(message4) + "The VSL syntax for collections must be used, i.e., '{'<EXPRESSION>(','<EXPRESSION>)*'}'";
                        this.error(message4, (EStructuralFeature)StereotypeApplicationWithVSLPackage.eINSTANCE.getExpressionValueRule_Expression());
                        valid_Expression = false;
                    } else {
                        valid_Expression = true;
                    }
                } else {
                    CollectionOrTuple cddColl = VSLJavaValidator.isACollection((Expression)expressionValueRule.getExpression());
                    if (cddColl != null) {
                        message = "The property " + valuedProperty.getName() + " is not a collection. The expression doest not match the expected multiplicity.";
                        this.error(message, (EStructuralFeature)StereotypeApplicationWithVSLPackage.eINSTANCE.getExpressionValueRule_Expression());
                        valid_Expression = false;
                    } else {
                        valid_Expression = true;
                    }
                }
            } else {
                this.error(validationResult.errorMessage(), validationResult.validatedRule(), validationResult.validatedFeature(), -1);
                valid_Expression = false;
            }
        }
    }
}

