/**
 * Copyright (c) 2010, 2016 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *
 */
package org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.CollectionType;
import org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.DataTypesPackage;

import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Collection Type</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.impl.CollectionTypeImpl#getCollectionAttrib <em>Collection Attrib</em>}</li>
 * <li>{@link org.eclipse.papyrus.MARTE.MARTE_Annexes.VSL.DataTypes.impl.CollectionTypeImpl#getBase_DataType <em>Base Data Type</em>}</li>
 * </ul>
 *
 * @generated
 */
public class CollectionTypeImpl extends EObjectImpl implements CollectionType {
	/**
	 * The cached value of the '{@link #getCollectionAttrib() <em>Collection Attrib</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getCollectionAttrib()
	 * @generated
	 * @ordered
	 */
	protected Property collectionAttrib;

	/**
	 * The cached value of the '{@link #getBase_DataType() <em>Base Data Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see #getBase_DataType()
	 * @generated
	 * @ordered
	 */
	protected DataType base_DataType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected CollectionTypeImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return DataTypesPackage.Literals.COLLECTION_TYPE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Property getCollectionAttrib() {
		if (collectionAttrib != null && collectionAttrib.eIsProxy()) {
			InternalEObject oldCollectionAttrib = (InternalEObject) collectionAttrib;
			collectionAttrib = (Property) eResolveProxy(oldCollectionAttrib);
			if (collectionAttrib != oldCollectionAttrib) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DataTypesPackage.COLLECTION_TYPE__COLLECTION_ATTRIB, oldCollectionAttrib, collectionAttrib));
				}
			}
		}
		return collectionAttrib;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public Property basicGetCollectionAttrib() {
		return collectionAttrib;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setCollectionAttrib(Property newCollectionAttrib) {
		Property oldCollectionAttrib = collectionAttrib;
		collectionAttrib = newCollectionAttrib;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DataTypesPackage.COLLECTION_TYPE__COLLECTION_ATTRIB, oldCollectionAttrib, collectionAttrib));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public DataType getBase_DataType() {
		if (base_DataType != null && base_DataType.eIsProxy()) {
			InternalEObject oldBase_DataType = (InternalEObject) base_DataType;
			base_DataType = (DataType) eResolveProxy(oldBase_DataType);
			if (base_DataType != oldBase_DataType) {
				if (eNotificationRequired()) {
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, DataTypesPackage.COLLECTION_TYPE__BASE_DATA_TYPE, oldBase_DataType, base_DataType));
				}
			}
		}
		return base_DataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public DataType basicGetBase_DataType() {
		return base_DataType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void setBase_DataType(DataType newBase_DataType) {
		DataType oldBase_DataType = base_DataType;
		base_DataType = newBase_DataType;
		if (eNotificationRequired()) {
			eNotify(new ENotificationImpl(this, Notification.SET, DataTypesPackage.COLLECTION_TYPE__BASE_DATA_TYPE, oldBase_DataType, base_DataType));
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
		case DataTypesPackage.COLLECTION_TYPE__COLLECTION_ATTRIB:
			if (resolve) {
				return getCollectionAttrib();
			}
			return basicGetCollectionAttrib();
		case DataTypesPackage.COLLECTION_TYPE__BASE_DATA_TYPE:
			if (resolve) {
				return getBase_DataType();
			}
			return basicGetBase_DataType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
		case DataTypesPackage.COLLECTION_TYPE__COLLECTION_ATTRIB:
			setCollectionAttrib((Property) newValue);
			return;
		case DataTypesPackage.COLLECTION_TYPE__BASE_DATA_TYPE:
			setBase_DataType((DataType) newValue);
			return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
		case DataTypesPackage.COLLECTION_TYPE__COLLECTION_ATTRIB:
			setCollectionAttrib((Property) null);
			return;
		case DataTypesPackage.COLLECTION_TYPE__BASE_DATA_TYPE:
			setBase_DataType((DataType) null);
			return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
		case DataTypesPackage.COLLECTION_TYPE__COLLECTION_ATTRIB:
			return collectionAttrib != null;
		case DataTypesPackage.COLLECTION_TYPE__BASE_DATA_TYPE:
			return base_DataType != null;
		}
		return super.eIsSet(featureID);
	}

} // CollectionTypeImpl
