/**
 * Copyright (c) 2010, 2016 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *
 */
package org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.Switch;

import org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.*;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.MARTE.MARTE_Foundations.GRM.GRMPackage
 * @generated
 */
public class GRMSwitch<T> extends Switch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	protected static GRMPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	public GRMSwitch() {
		if (modelPackage == null) {
			modelPackage = GRMPackage.eINSTANCE;
		}
	}

	/**
	 * Checks whether this is a switch for the given package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @param ePackage
	 *            the package in question.
	 * @return whether this is a switch for the given package.
	 * @generated
	 */
	@Override
	protected boolean isSwitchFor(EPackage ePackage) {
		return ePackage == modelPackage;
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	@Override
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
		case GRMPackage.RESOURCE: {
			Resource resource = (Resource) theEObject;
			T result = caseResource(resource);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.STORAGE_RESOURCE: {
			StorageResource storageResource = (StorageResource) theEObject;
			T result = caseStorageResource(storageResource);
			if (result == null) {
				result = caseResource(storageResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.COMMUNICATION_END_POINT: {
			CommunicationEndPoint communicationEndPoint = (CommunicationEndPoint) theEObject;
			T result = caseCommunicationEndPoint(communicationEndPoint);
			if (result == null) {
				result = caseResource(communicationEndPoint);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.SYNCHRONIZATION_RESOURCE: {
			SynchronizationResource synchronizationResource = (SynchronizationResource) theEObject;
			T result = caseSynchronizationResource(synchronizationResource);
			if (result == null) {
				result = caseResource(synchronizationResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.CONCURRENCY_RESOURCE: {
			ConcurrencyResource concurrencyResource = (ConcurrencyResource) theEObject;
			T result = caseConcurrencyResource(concurrencyResource);
			if (result == null) {
				result = caseResource(concurrencyResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.SCHEDULER: {
			Scheduler scheduler = (Scheduler) theEObject;
			T result = caseScheduler(scheduler);
			if (result == null) {
				result = caseResource(scheduler);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.PROCESSING_RESOURCE: {
			ProcessingResource processingResource = (ProcessingResource) theEObject;
			T result = caseProcessingResource(processingResource);
			if (result == null) {
				result = caseResource(processingResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.COMPUTING_RESOURCE: {
			ComputingResource computingResource = (ComputingResource) theEObject;
			T result = caseComputingResource(computingResource);
			if (result == null) {
				result = caseProcessingResource(computingResource);
			}
			if (result == null) {
				result = caseResource(computingResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.MUTUAL_EXCLUSION_RESOURCE: {
			MutualExclusionResource mutualExclusionResource = (MutualExclusionResource) theEObject;
			T result = caseMutualExclusionResource(mutualExclusionResource);
			if (result == null) {
				result = caseResource(mutualExclusionResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.SCHEDULABLE_RESOURCE: {
			SchedulableResource schedulableResource = (SchedulableResource) theEObject;
			T result = caseSchedulableResource(schedulableResource);
			if (result == null) {
				result = caseResource(schedulableResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.SECONDARY_SCHEDULER: {
			SecondaryScheduler secondaryScheduler = (SecondaryScheduler) theEObject;
			T result = caseSecondaryScheduler(secondaryScheduler);
			if (result == null) {
				result = caseScheduler(secondaryScheduler);
			}
			if (result == null) {
				result = caseResource(secondaryScheduler);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.COMMUNICATION_MEDIA: {
			CommunicationMedia communicationMedia = (CommunicationMedia) theEObject;
			T result = caseCommunicationMedia(communicationMedia);
			if (result == null) {
				result = caseProcessingResource(communicationMedia);
			}
			if (result == null) {
				result = caseResource(communicationMedia);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.DEVICE_RESOURCE: {
			DeviceResource deviceResource = (DeviceResource) theEObject;
			T result = caseDeviceResource(deviceResource);
			if (result == null) {
				result = caseProcessingResource(deviceResource);
			}
			if (result == null) {
				result = caseResource(deviceResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.TIMING_RESOURCE: {
			TimingResource timingResource = (TimingResource) theEObject;
			T result = caseTimingResource(timingResource);
			if (result == null) {
				result = caseResource(timingResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.CLOCK_RESOURCE: {
			ClockResource clockResource = (ClockResource) theEObject;
			T result = caseClockResource(clockResource);
			if (result == null) {
				result = caseTimingResource(clockResource);
			}
			if (result == null) {
				result = caseResource(clockResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.TIMER_RESOURCE: {
			TimerResource timerResource = (TimerResource) theEObject;
			T result = caseTimerResource(timerResource);
			if (result == null) {
				result = caseTimingResource(timerResource);
			}
			if (result == null) {
				result = caseResource(timerResource);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.GR_SERVICE: {
			GrService grService = (GrService) theEObject;
			T result = caseGrService(grService);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.RELEASE: {
			Release release = (Release) theEObject;
			T result = caseRelease(release);
			if (result == null) {
				result = caseGrService(release);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.ACQUIRE: {
			Acquire acquire = (Acquire) theEObject;
			T result = caseAcquire(acquire);
			if (result == null) {
				result = caseGrService(acquire);
			}
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		case GRMPackage.RESOURCE_USAGE: {
			ResourceUsage resourceUsage = (ResourceUsage) theEObject;
			T result = caseResourceUsage(resourceUsage);
			if (result == null) {
				result = defaultCase(theEObject);
			}
			return result;
		}
		default:
			return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseResource(Resource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Storage Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Storage Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseStorageResource(StorageResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Communication End Point</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Communication End Point</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCommunicationEndPoint(CommunicationEndPoint object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Synchronization Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Synchronization Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSynchronizationResource(SynchronizationResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Concurrency Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Concurrency Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseConcurrencyResource(ConcurrencyResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Scheduler</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Scheduler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseScheduler(Scheduler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Processing Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Processing Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseProcessingResource(ProcessingResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Computing Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Computing Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComputingResource(ComputingResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Mutual Exclusion Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Mutual Exclusion Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMutualExclusionResource(MutualExclusionResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Schedulable Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Schedulable Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSchedulableResource(SchedulableResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Secondary Scheduler</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Secondary Scheduler</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSecondaryScheduler(SecondaryScheduler object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Communication Media</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Communication Media</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCommunicationMedia(CommunicationMedia object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Device Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Device Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseDeviceResource(DeviceResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Timing Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Timing Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimingResource(TimingResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Clock Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Clock Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseClockResource(ClockResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Timer Resource</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Timer Resource</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTimerResource(TimerResource object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gr Service</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gr Service</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGrService(GrService object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Release</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Release</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseRelease(Release object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Acquire</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Acquire</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAcquire(Acquire object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Resource Usage</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Resource Usage</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseResourceUsage(ResourceUsage object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 *
	 * @param object
	 *            the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	@Override
	public T defaultCase(EObject object) {
		return null;
	}

} // GRMSwitch
