/**
 * Copyright (c) 2010, 2016 CEA LIST.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Chokri MRAIDHA (CEA LIST) chokri.mraidha@cea.fr - Initial API and implementation
 *
 */
package org.eclipse.papyrus.MARTE_Library.RS_Library;

import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 * <li>each class,</li>
 * <li>each feature of each class,</li>
 * <li>each enum,</li>
 * <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 *
 * @see org.eclipse.papyrus.MARTE_Library.RS_Library.RS_LibraryFactory
 * @model kind="package"
 * @generated
 */
public interface RS_LibraryPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNAME = "RS_Library"; //$NON-NLS-1$

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNS_URI = "http:///MARTE_Library/RS_Library.ecore"; //$NON-NLS-1$

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	String eNS_PREFIX = "MARTE_Library.RS_Library"; //$NON-NLS-1$

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	RS_LibraryPackage eINSTANCE = org.eclipse.papyrus.MARTE_Library.RS_Library.impl.RS_LibraryPackageImpl.init();

	/**
	 * The meta object id for the '<em>Tiler Specification</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see java.lang.String
	 * @see org.eclipse.papyrus.MARTE_Library.RS_Library.impl.RS_LibraryPackageImpl#getTilerSpecification()
	 * @generated
	 */
	int TILER_SPECIFICATION = 0;

	/**
	 * The meta object id for the '<em>Shape Specification</em>' data type.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @see java.lang.String
	 * @see org.eclipse.papyrus.MARTE_Library.RS_Library.impl.RS_LibraryPackageImpl#getShapeSpecification()
	 * @generated
	 */
	int SHAPE_SPECIFICATION = 1;


	/**
	 * Returns the meta object for data type '{@link java.lang.String <em>Tiler Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for data type '<em>Tiler Specification</em>'.
	 * @see java.lang.String
	 * @model instanceClass="java.lang.String"
	 * @generated
	 */
	EDataType getTilerSpecification();

	/**
	 * Returns the meta object for data type '{@link java.lang.String <em>Shape Specification</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the meta object for data type '<em>Shape Specification</em>'.
	 * @see java.lang.String
	 * @model instanceClass="java.lang.String"
	 * @generated
	 */
	EDataType getShapeSpecification();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 *
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	RS_LibraryFactory getRS_LibraryFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 * <li>each class,</li>
	 * <li>each feature of each class,</li>
	 * <li>each enum,</li>
	 * <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 *
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '<em>Tiler Specification</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see java.lang.String
		 * @see org.eclipse.papyrus.MARTE_Library.RS_Library.impl.RS_LibraryPackageImpl#getTilerSpecification()
		 * @generated
		 */
		EDataType TILER_SPECIFICATION = eINSTANCE.getTilerSpecification();

		/**
		 * The meta object literal for the '<em>Shape Specification</em>' data type.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 *
		 * @see java.lang.String
		 * @see org.eclipse.papyrus.MARTE_Library.RS_Library.impl.RS_LibraryPackageImpl#getShapeSpecification()
		 * @generated
		 */
		EDataType SHAPE_SPECIFICATION = eINSTANCE.getShapeSpecification();

	}

} // RS_LibraryPackage
