/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.odt.internal.listener;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.infra.core.sashwindows.di.DiPackage;
import org.eclipse.papyrus.infra.core.sashwindows.di.PageRef;
import org.eclipse.papyrus.model2doc.core.service.WorkspaceResourceServiceImpl;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.odt.service.ODTEditorServiceImpl;
import org.eclipse.papyrus.model2doc.odt.service.ODTFileIOServiceImpl;

public class OpenCloseODTDocumentListener
implements IContentChangedListener {
    public void contentChanged(IContentChangedListener.ContentEvent event) {
        if (event instanceof Notification) {
            Notification notification = (Notification)event;
            Object newValue = notification.getNewValue();
            Object oldValue = notification.getOldValue();
            Object feature = notification.getFeature();
            int eventType = notification.getEventType();
            EObject referencedPage = null;
            if (eventType == 3 && newValue instanceof PageRef) {
                referencedPage = ((PageRef)newValue).getEmfPageIdentifier();
                if (referencedPage instanceof Document && feature == DiPackage.eINSTANCE.getTabFolder_Children()) {
                    this.openDocument((Document)referencedPage);
                }
            } else if (eventType == 4 && oldValue instanceof PageRef && newValue == null && (referencedPage = ((PageRef)oldValue).getEmfPageIdentifier()) instanceof Document && feature == DiPackage.eINSTANCE.getTabFolder_Children()) {
                this.closeDocument((Document)referencedPage);
            }
        }
    }

    private void closeDocument(Document document) {
        if (document != null && document.getDocumentKind().matches("odt")) {
            WorkspaceResourceServiceImpl workspaceResourceService = new WorkspaceResourceServiceImpl();
            String projectFolder = workspaceResourceService.calculateProjectFolder(document.getContext());
            ODTEditorServiceImpl odtEditorService = new ODTEditorServiceImpl();
            ODTFileIOServiceImpl odtFileIOService = new ODTFileIOServiceImpl();
            String generatedDocumentPath = odtFileIOService.updatePathOfFileInWorkspace(document.getGeneratedDocumentFileURI());
            if (generatedDocumentPath != null && !generatedDocumentPath.isEmpty()) {
                odtEditorService.closeDocument(projectFolder, String.valueOf(odtFileIOService.getODTFilePrefix()) + generatedDocumentPath);
            }
        }
    }

    private void openDocument(Document document) {
        if (document != null && document.getDocumentKind().matches("odt")) {
            WorkspaceResourceServiceImpl workspaceResourceService = new WorkspaceResourceServiceImpl();
            String projectFolder = workspaceResourceService.calculateProjectFolder(document.getContext());
            ODTEditorServiceImpl odtEditorService = new ODTEditorServiceImpl();
            ODTFileIOServiceImpl odtFileIOService = new ODTFileIOServiceImpl();
            String generatedDocumentPath = odtFileIOService.updatePathOfFileInWorkspace(document.getGeneratedDocumentFileURI());
            if (generatedDocumentPath != null && !generatedDocumentPath.isEmpty()) {
                odtEditorService.openDocument(projectFolder, String.valueOf(odtFileIOService.getODTFilePrefix()) + generatedDocumentPath);
            }
        }
    }
}

