/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.template2structure.internal.mapping;

import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.model2doc.emf.template2structure.Activator;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.AbstractTemplateToStructureMapper;
import org.eclipse.papyrus.model2doc.emf.template2structure.mapping.IMappingService;

public final class TemplateToStructureMappingService
implements IMappingService {
    private final List<AbstractTemplateToStructureMapper<?>> mappers;

    public TemplateToStructureMappingService(List<AbstractTemplateToStructureMapper<?>> mappers) {
        this.mappers = mappers;
    }

    private AbstractTemplateToStructureMapper<?> getContributorFor(EObject documentTemplateElement, Class<?> expectedReturnedEClass) {
        return this.getContributorFor(documentTemplateElement.eClass(), expectedReturnedEClass);
    }

    private AbstractTemplateToStructureMapper<?> getContributorFor(EClass eClassTemplateElement, Class<?> expectedReturnedEClass) {
        AbstractTemplateToStructureMapper<?> contributor = null;
        ListIterator<AbstractTemplateToStructureMapper<?>> iter = this.mappers.listIterator();
        while (iter.hasNext() && contributor == null) {
            AbstractTemplateToStructureMapper<?> current = iter.next();
            if (!current.handlesInput(eClassTemplateElement) || !current.handlesExpectedOutput(expectedReturnedEClass)) continue;
            contributor = current;
        }
        if (contributor == null) {
            Activator.log.info(NLS.bind((String)"No Mapper found for input {0} and output {1}.", (Object)eClassTemplateElement, expectedReturnedEClass));
        }
        return contributor;
    }

    @Override
    public <T> List<T> map(EObject documentTemplateElement, EObject semanticModelElement, Class<T> expectedReturnedClass) {
        AbstractTemplateToStructureMapper<?> contributor = this.getContributorFor(documentTemplateElement, expectedReturnedClass);
        List<T> result = null;
        if (contributor != null) {
            result = contributor.map(this, documentTemplateElement, semanticModelElement, expectedReturnedClass);
            if (result == null) {
                Activator.log.info(NLS.bind((String)"Mapping failed for input {0} and output {1}.", (Object)documentTemplateElement, expectedReturnedClass));
                result = Collections.emptyList();
            }
        } else {
            Activator.log.info(NLS.bind((String)"No mapper found for input {0} with an output of kind {1}.", (Object)documentTemplateElement, expectedReturnedClass));
        }
        return result;
    }
}

