/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.internal.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.gmfdiag.common.model.NotationUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.model2doc.core.Activator;
import org.eclipse.papyrus.model2doc.core.transcription.ImageDescription;
import org.eclipse.papyrus.model2doc.core.transcription.ImageDescriptionFactory;
import org.eclipse.uml2.uml.Element;

public class DiagramToImageUtil {
    private static final String SPACE = " ";
    private static final String UNDERLINE = "_";
    private static final String SVG_EXTENSION = ".svg";

    private DiagramToImageUtil() {
    }

    public static List<ImageDescription> getImagesOfDiagrams(Element owner, String outputFolder) {
        ArrayList<ImageDescription> images = new ArrayList<ImageDescription>();
        String pathRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        List<Diagram> diagrams = DiagramToImageUtil.getAllDiagrams(owner);
        if (!diagrams.isEmpty()) {
            Iterator<Diagram> iteratorDiagrams = diagrams.iterator();
            while (iteratorDiagrams.hasNext()) {
                images.add(DiagramToImageUtil.generateImageOfDiagram(iteratorDiagrams.next(), pathRoot));
            }
        }
        return images;
    }

    public static List<Diagram> getAllDiagrams(Element owner) {
        ArrayList<Diagram> diagrams = new ArrayList<Diagram>();
        Iterable roots = NotationUtils.getAllNotations((ResourceSet)owner.eResource().getResourceSet());
        for (EObject root : roots) {
            if (!(root instanceof Diagram) || !EcoreUtil.equals((EObject)DiagramUtils.getOwner((Diagram)((Diagram)root)), (EObject)owner)) continue;
            diagrams.add((Diagram)root);
        }
        return diagrams;
    }

    public static ImageDescription generateImageOfDiagram(Diagram diagram, String pathRoot) {
        ImageDescription image = ImageDescriptionFactory.INSTANCE.getDefaultImageDescription();
        StringBuilder fullPath = new StringBuilder();
        fullPath.append(pathRoot);
        fullPath.append(File.separator);
        fullPath.append(DiagramToImageUtil.generateImageFileName(diagram));
        Path imagePath = new Path(fullPath.toString());
        if (!new File(imagePath.toString()).exists()) {
            CopyToImageUtil copyImageUtil = new CopyToImageUtil();
            try {
                copyImageUtil.copyToImage(diagram, (IPath)imagePath, ImageFileFormat.SVG, (IProgressMonitor)new NullProgressMonitor(), PreferencesHint.USE_DEFAULTS);
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
        }
        image.setPath(imagePath.toString());
        image.setSubtitle(diagram.getName());
        return image;
    }

    private static String generateImageFileName(Diagram diagram) {
        StringBuilder imageFileNameBuilder = new StringBuilder();
        String fileName = diagram.getName().replaceAll(SPACE, UNDERLINE);
        imageFileNameBuilder.append(fileName);
        imageFileNameBuilder.append(new Date().getTime());
        imageFileNameBuilder.append(SVG_EXTENSION);
        return imageFileNameBuilder.toString();
    }
}

