/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.profile.types.generator;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.papyrus.infra.types.AbstractAdviceBindingConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypeSetConfiguration;
import org.eclipse.papyrus.infra.types.ElementTypesConfigurationsFactory;
import org.eclipse.papyrus.infra.types.SpecializationTypeConfiguration;
import org.eclipse.papyrus.uml.profile.types.generator.ApplyStereotypeAdviceRule;
import org.eclipse.papyrus.uml.profile.types.generator.ElementTypeRule;
import org.eclipse.papyrus.uml.profile.types.generator.Identifiers;
import org.eclipse.papyrus.uml.profile.types.generator.ImpliedExtension;
import org.eclipse.papyrus.uml.profile.types.generator.UML;
import org.eclipse.papyrus.uml.profile.types.generator.UMLElementTypes;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@Singleton
public class ConfigurationSetRule {
    @Extension
    private static ElementTypesConfigurationsFactory elementtypesconfigurationsFactory = ElementTypesConfigurationsFactory.eINSTANCE;
    @Inject
    @Extension
    private Identifiers _identifiers;
    @Inject
    @Extension
    private UML _uML;
    @Inject
    @Extension
    private UMLElementTypes _uMLElementTypes;
    @Inject
    @Extension
    private ElementTypeRule _elementTypeRule;
    @Inject
    @Extension
    private ApplyStereotypeAdviceRule _applyStereotypeAdviceRule;
    private static List<ElementTypeConfiguration> elementTypeConfigurationList;
    private List<AbstractAdviceBindingConfiguration> adviceBindingConfigurationList;
    private final HashMap<ArrayList<?>, ElementTypeSetConfiguration> _createCache_toConfigurationSet = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public static ElementTypeConfiguration addElementType(final ElementTypeConfiguration elementtype) {
        Functions.Function1<ElementTypeConfiguration, Boolean> _function = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

            public Boolean apply(ElementTypeConfiguration el) {
                return el.getIdentifier().equals(elementtype.getIdentifier());
            }
        };
        ElementTypeConfiguration found = (ElementTypeConfiguration)IterableExtensions.findFirst(elementTypeConfigurationList, (Functions.Function1)_function);
        boolean _equals = Objects.equal((Object)found, null);
        if (_equals) {
            elementTypeConfigurationList.add(elementtype);
            return elementtype;
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElementTypeSetConfiguration toConfigurationSet(Profile umlProfile) {
        ElementTypeSetConfiguration _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Profile[]{umlProfile});
        HashMap<ArrayList<?>, ElementTypeSetConfiguration> hashMap = this._createCache_toConfigurationSet;
        synchronized (hashMap) {
            ElementTypeSetConfiguration _createElementTypeSetConfiguration;
            if (this._createCache_toConfigurationSet.containsKey(_cacheKey)) {
                return this._createCache_toConfigurationSet.get(_cacheKey);
            }
            _result = _createElementTypeSetConfiguration = elementtypesconfigurationsFactory.createElementTypeSetConfiguration();
            this._createCache_toConfigurationSet.put(_cacheKey, _result);
        }
        this._init_toConfigurationSet(_result, umlProfile);
        return _result;
    }

    private void _init_toConfigurationSet(ElementTypeSetConfiguration it, Profile umlProfile) {
        elementTypeConfigurationList = CollectionLiterals.newArrayList((Object[])new ElementTypeConfiguration[0]);
        this.adviceBindingConfigurationList = CollectionLiterals.newArrayList((Object[])new AbstractAdviceBindingConfiguration[0]);
        this._identifiers.setIdentifierBase((Package)umlProfile);
        it.setIdentifier(this._identifiers.getQualified("elementTypes"));
        String _elvis = null;
        ElementTypeSetConfiguration _baseUMLElementTypeSet = this._uMLElementTypes.getBaseUMLElementTypeSet();
        String _metamodelNsURI = null;
        if (_baseUMLElementTypeSet != null) {
            _metamodelNsURI = _baseUMLElementTypeSet.getMetamodelNsURI();
        }
        _elvis = _metamodelNsURI != null ? _metamodelNsURI : "http://www.eclipse.org/uml2/5.0.0/UML";
        it.setMetamodelNsURI(_elvis);
        Iterable<ImpliedExtension> _allExtensions = this._uML.getAllExtensions((Package)umlProfile);
        for (ImpliedExtension ext : _allExtensions) {
            Iterable<? extends ElementTypeConfiguration> _diagramSpecificElementTypes = this._uMLElementTypes.getDiagramSpecificElementTypes(ext.getMetaclass());
            for (ElementTypeConfiguration elementTypeConfiguration : _diagramSpecificElementTypes) {
                SpecializationTypeConfiguration elementtype = this._elementTypeRule.toElementType(ext, elementTypeConfiguration);
                elementTypeConfigurationList.add((ElementTypeConfiguration)elementtype);
            }
            Functions.Function1<ElementTypeConfiguration, Boolean> function1 = new Functions.Function1<ElementTypeConfiguration, Boolean>(){

                public Boolean apply(ElementTypeConfiguration it) {
                    boolean _hasSemanticSupertype = ConfigurationSetRule.this._uMLElementTypes.hasSemanticSupertype(it);
                    return !_hasSemanticSupertype;
                }
            };
            Iterable typesNeedingAdvice = IterableExtensions.filter(this._uMLElementTypes.getDiagramSpecificElementTypes(ext.getMetaclass()), (Functions.Function1)function1);
            for (ElementTypeConfiguration element_1 : typesNeedingAdvice) {
                ApplyStereotypeAdviceConfiguration advice = this._applyStereotypeAdviceRule.toAdviceConfiguration(ext.getStereotype(), ext, element_1);
                this.adviceBindingConfigurationList.add((AbstractAdviceBindingConfiguration)advice);
            }
        }
        Functions.Function1<AbstractAdviceBindingConfiguration, String> _function = new Functions.Function1<AbstractAdviceBindingConfiguration, String>(){

            public String apply(AbstractAdviceBindingConfiguration it) {
                return it.getIdentifier();
            }
        };
        it.getAdviceBindingsConfigurations().addAll((Collection)IterableExtensions.sortBy(this.adviceBindingConfigurationList, (Functions.Function1)_function));
        Functions.Function1<ElementTypeConfiguration, String> _function_1 = new Functions.Function1<ElementTypeConfiguration, String>(){

            public String apply(ElementTypeConfiguration it) {
                return it.getIdentifier();
            }
        };
        it.getElementTypeConfigurations().addAll((Collection)IterableExtensions.sortBy(elementTypeConfigurationList, (Functions.Function1)_function_1));
    }
}

