/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.uml2.uml.ExecutionOccurrenceSpecification;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.Interaction;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageEnd;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.UMLFactory;

public class ExecutionSpecificationHelperAdvice
extends AbstractEditHelperAdvice {
    public static ExecutionOccurrenceSpecification createOccurenceSpecification(ExecutionSpecification execution, Lifeline lifeline) {
        ExecutionOccurrenceSpecification occurrenceSpecification = UMLFactory.eINSTANCE.createExecutionOccurrenceSpecification();
        occurrenceSpecification.setCovered(lifeline);
        ((Interaction)execution.getOwner()).getFragments().add((Object)occurrenceSpecification);
        return occurrenceSpecification;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        ExecutionSpecification execution = (ExecutionSpecification)request.getElementToConfigure();
        IElementType elementType = request.getTypeToConfigure();
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Object coveredParam = request.getParameters().get("Element Covers this one");
                Lifeline coveredLifeline = null;
                if (coveredParam instanceof Lifeline) {
                    coveredLifeline = (Lifeline)coveredParam;
                }
                ExecutionSpecification execution = (ExecutionSpecification)request.getElementToConfigure();
                Object replaceStart = request.getParameters().get("REPLACE_EXECUTION_SPECIFICATION_START");
                if (replaceStart instanceof MessageOccurrenceSpecification) {
                    execution.setStart((OccurrenceSpecification)((MessageOccurrenceSpecification)replaceStart));
                } else {
                    ExecutionOccurrenceSpecification start = ExecutionSpecificationHelperAdvice.createOccurenceSpecification(execution, coveredLifeline);
                    start.setName(String.valueOf(execution.getName()) + "Start");
                    start.setExecution(execution);
                    execution.setStart((OccurrenceSpecification)start);
                }
                coveredLifeline.getCoveredBys().add((Object)execution);
                execution.getCovereds().add((Object)coveredLifeline);
                Object replaceFinish = request.getParameters().get("REPLACE_EXECUTION_SPECIFICATION_FINISH");
                if (replaceFinish instanceof MessageOccurrenceSpecification) {
                    execution.setFinish((OccurrenceSpecification)((MessageOccurrenceSpecification)replaceFinish));
                } else {
                    ExecutionOccurrenceSpecification finish = ExecutionSpecificationHelperAdvice.createOccurenceSpecification(execution, coveredLifeline);
                    finish.setName(String.valueOf(execution.getName()) + "Finish");
                    finish.setExecution(execution);
                    execution.setFinish((OccurrenceSpecification)finish);
                }
                return CommandResult.newOKCommandResult((Object)execution);
            }
        };
    }

    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        OccurrenceSpecification osFinish;
        OccurrenceSpecification osStart;
        ArrayList<OccurrenceSpecification> dependentsToDestroy = new ArrayList<OccurrenceSpecification>();
        ExecutionSpecification es = (ExecutionSpecification)request.getElementToDestroy();
        if (this.shouldDestroyOccurrenceSpecification(es, osStart = es.getStart()) && !(osStart instanceof MessageEnd)) {
            dependentsToDestroy.add(osStart);
        }
        if (this.shouldDestroyOccurrenceSpecification(es, osFinish = es.getFinish()) && !(osFinish instanceof MessageEnd)) {
            dependentsToDestroy.add(osFinish);
        }
        HashSet coveredLifelines = new HashSet(es.getCovereds());
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }

    private boolean shouldDestroyOccurrenceSpecification(ExecutionSpecification es, OccurrenceSpecification os) {
        return os instanceof ExecutionOccurrenceSpecification || os != null && EMFHelper.isOnlyUsage((EObject)os, (EObject)es);
    }
}

