/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.viewpoints.policy;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ui.PlatformUI;

public class NotationUtils {
    public static Iterator<EObject> getNotationRoots(EObject element) {
        Iterator<Resource> notations = NotationUtils.getNotationResources(element);
        if (notations == null) {
            return null;
        }
        return new RootsIterator(notations);
    }

    public static Iterator<Resource> getNotationResources(EObject element) {
        Iterator<Resource> result = NotationUtils.tryGetNotationResources(element);
        if (result != null) {
            return result;
        }
        IAdaptable input = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getInput();
        if (input != null) {
            EObject obj = (EObject)input.getAdapter(EObject.class);
            return NotationUtils.tryGetNotationResources(obj);
        }
        return null;
    }

    private static Iterator<Resource> tryGetNotationResources(EObject element) {
        if (element == null) {
            return null;
        }
        if (element.eResource() == null) {
            return null;
        }
        return new NotationsIterator(element.eResource().getResourceSet());
    }

    private static class NotationsIterator
    implements Iterator<Resource> {
        private List<Resource> resources;
        private int cursor;
        private Resource next;

        public NotationsIterator(ResourceSet set) {
            this.resources = set.getResources();
            this.next = this.getNextNotation();
        }

        private Resource getNextNotation() {
            while (this.cursor < this.resources.size()) {
                Resource resource;
                String uri;
                if (!(uri = (resource = this.resources.get(this.cursor++)).getURI().toString()).endsWith(".notation")) continue;
                return resource;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Resource next() {
            Resource result = this.next;
            this.next = this.getNextNotation();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class RootsIterator
    implements Iterator<EObject> {
        private Iterator<Resource> notations;
        private Iterator<EObject> inner;

        public RootsIterator(Iterator<Resource> notations) {
            this.notations = notations;
            if (notations.hasNext()) {
                this.inner = notations.next().getAllContents();
            }
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.inner == null) {
                return false;
            }
            if (!this.inner.hasNext()) ** GOTO lbl8
            return true;
lbl-1000:
            // 1 sources

            {
                this.inner = this.notations.next().getAllContents();
                if (!this.inner.hasNext()) continue;
                return true;
lbl8:
                // 2 sources

                ** while (this.notations.hasNext())
            }
lbl9:
            // 1 sources

            this.inner = null;
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public EObject next() {
            if (this.inner == null) {
                return null;
            }
            if (!this.inner.hasNext()) ** GOTO lbl8
            return this.inner.next();
lbl-1000:
            // 1 sources

            {
                this.inner = this.notations.next().getAllContents();
                if (!this.inner.hasNext()) continue;
                return this.inner.next();
lbl8:
                // 2 sources

                ** while (this.notations.hasNext())
            }
lbl9:
            // 1 sources

            this.inner = null;
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

