/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.internationalization.edit.providers;

import java.util.Collection;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferenceChangeEvent;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferenceListener;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.internationalization.edit.internal.providers.InternationalizationUMLItemProviderAdapterFactoryImpl;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

public class InternationalizationUMLItemProviderAdapterFactory
extends InternationalizationUMLItemProviderAdapterFactoryImpl {
    private final UMLItemProviderAdapterFactory uml = new UMLItemProviderAdapterFactory();
    private final Map<ResourceSet, Boolean> resourceSets = new WeakHashMap<ResourceSet, Boolean>();
    private final Adapter resourceSetAdapter = this.createResourceSetAdapter();
    private final InternationalizationPreferenceListener prefListener = this.createPreferenceListener();

    public InternationalizationUMLItemProviderAdapterFactory() {
        InternationalizationPreferencesUtils.addPreferenceListener((InternationalizationPreferenceListener)this.prefListener);
    }

    public void dispose() {
        InternationalizationPreferencesUtils.removePreferenceListener((InternationalizationPreferenceListener)this.prefListener);
        for (ResourceSet next : this.resourceSets.keySet()) {
            next.eAdapters().remove((Object)this.resourceSetAdapter);
        }
        this.resourceSets.clear();
        this.uml.dispose();
        super.dispose();
    }

    private InternationalizationPreferenceListener createPreferenceListener() {
        return new InternationalizationPreferenceListener(){

            public void internationalizationChanged(InternationalizationPreferenceChangeEvent event) {
                switch (event.getEventType()) {
                    case 0: {
                        if (!event.isInternationalizationEnabled() || InternationalizationUMLItemProviderAdapterFactory.this.resourceSets.isEmpty()) break;
                        for (Map.Entry entry : InternationalizationUMLItemProviderAdapterFactory.this.resourceSets.entrySet()) {
                            if (((ResourceSet)entry.getKey()).getResource(event.getResourceURI(), false) == null) continue;
                            entry.setValue(true);
                            ((ResourceSet)entry.getKey()).eAdapters().remove((Object)InternationalizationUMLItemProviderAdapterFactory.this.resourceSetAdapter);
                            InternationalizationUMLItemProviderAdapterFactory.this.uml.dispose();
                        }
                        break;
                    }
                }
            }
        };
    }

    private Adapter createResourceSetAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (msg.isTouch()) {
                    return;
                }
                block0 : switch (msg.getFeatureID(ResourceSet.class)) {
                    case 0: {
                        switch (msg.getEventType()) {
                            case 3: {
                                InternationalizationUMLItemProviderAdapterFactory.this.checkResource((Resource)msg.getNewValue());
                                break;
                            }
                            case 5: {
                                for (Object next : (Collection)msg.getNewValue()) {
                                    if (InternationalizationUMLItemProviderAdapterFactory.this.checkResource((Resource)next)) break block0;
                                }
                                break block0;
                            }
                            case 1: {
                                InternationalizationUMLItemProviderAdapterFactory.this.checkResource((Resource)msg.getNewValue());
                            }
                        }
                        break;
                    }
                }
            }
        };
    }

    public Adapter createAdapter(Notifier target) {
        if (target instanceof EObject) {
            return this.needsInterationalization((EObject)target) ? super.createAdapter(target) : this.uml.createAdapter(target);
        }
        return super.createAdapter(target);
    }

    protected final boolean needsInterationalization(EObject object) {
        ResourceSet rset;
        Resource resource = object.eResource();
        if (resource != null && (rset = resource.getResourceSet()) != null) {
            this.initializeI18n(rset);
            return this.resourceSets.get(rset);
        }
        return true;
    }

    private void initializeI18n(ResourceSet resourceSet) {
        if (!this.resourceSets.containsKey(resourceSet)) {
            for (Resource next : resourceSet.getResources()) {
                if (!this.checkResource(next)) continue;
                return;
            }
            this.resourceSets.put(resourceSet, false);
            resourceSet.eAdapters().add((Object)this.resourceSetAdapter);
        }
    }

    boolean checkResource(Resource resource) {
        if (InternationalizationPreferencesUtils.getInternationalizationPreference((Resource)resource)) {
            ResourceSet rset = resource.getResourceSet();
            rset.eAdapters().remove((Object)this.resourceSetAdapter);
            this.resourceSets.put(rset, true);
            return true;
        }
        return false;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        super.addListener(notifyChangedListener);
        this.uml.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.uml.removeListener(notifyChangedListener);
        super.removeListener(notifyChangedListener);
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        super.setParentAdapterFactory(parentAdapterFactory);
        this.uml.setParentAdapterFactory(parentAdapterFactory);
    }
}

