/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.advices.applystereotype;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.types.core.Activator;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.ApplyStereotypeAdviceConfiguration;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.FeatureToSet;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.FeatureValue;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeFeatureValueUtils;
import org.eclipse.papyrus.uml.types.core.advices.applystereotype.StereotypeToApply;
import org.eclipse.papyrus.uml.types.core.requests.ApplyStereotypeRequest;
import org.eclipse.papyrus.uml.types.core.requests.SetStereotypeValueRequest;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class ApplyStereotypeAdviceEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected ApplyStereotypeAdviceConfiguration configuration;

    public ApplyStereotypeAdviceEditHelperAdvice(ApplyStereotypeAdviceConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        if (request instanceof CreateElementRequest) {
            if (this.configuration == null) {
                return false;
            }
            if (!(((CreateElementRequest)request).getContainer() instanceof Element)) {
                return false;
            }
            Element container = (Element)((CreateElementRequest)request).getContainer();
            Package nearestPackage = container.getNearestPackage();
            if (nearestPackage == null) {
                return false;
            }
            EList appliedProfiles = nearestPackage.getAllAppliedProfiles();
            if (appliedProfiles == null) {
                return false;
            }
            ArrayList<String> appliedProfileNames = new ArrayList<String>();
            for (Profile profile : appliedProfiles) {
                appliedProfileNames.add(profile.getQualifiedName());
            }
            for (StereotypeToApply stereotypeToApply : this.configuration.getStereotypesToApply()) {
                EList<String> requiredProfiles = stereotypeToApply.getRequiredProfiles();
                if (requiredProfiles == null) continue;
                for (String requiredProfile : requiredProfiles) {
                    if (appliedProfileNames.contains(requiredProfile)) continue;
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    public void configureRequest(IEditCommandRequest request) {
        super.configureRequest(request);
        StereotypeToApply namingStereotype = null;
        for (StereotypeToApply current : this.configuration.getStereotypesToApply()) {
            if (!current.isUpdateName()) continue;
            namingStereotype = current;
        }
        if (namingStereotype != null) {
            request.setParameter("baseNameToSet", (Object)NamedElementUtil.getNameFromQualifiedName((String)namingStereotype.getStereotypeQualifiedName()));
        }
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        if (this.configuration == null) {
            return null;
        }
        ICommand resultCommand = null;
        EObject elementToConfigure = request.getElementToConfigure();
        if (!(elementToConfigure instanceof Element)) {
            return null;
        }
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (editingDomain == null) {
            return null;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)elementToConfigure);
        if (service == null) {
            Activator.log.error(NLS.bind((String)"Impossible to get edit service from element: {0}.", (Object)elementToConfigure), null);
            return null;
        }
        for (StereotypeToApply stereotypeToApply : this.configuration.getStereotypesToApply()) {
            Stereotype stereotype = ((Element)elementToConfigure).getApplicableStereotype(stereotypeToApply.getStereotypeQualifiedName());
            if (stereotype == null) continue;
            ICommand applyStereotypeCommand = service.getEditCommand((IEditCommandRequest)new ApplyStereotypeRequest((Element)elementToConfigure, stereotype, editingDomain));
            resultCommand = resultCommand == null ? applyStereotypeCommand : resultCommand.compose((IUndoableOperation)applyStereotypeCommand);
            for (FeatureToSet featureToSet : stereotypeToApply.getFeaturesToSet()) {
                ICommand command = this.getSetStereotypeFeatureValueCommand((Element)elementToConfigure, stereotype, featureToSet.getFeatureName(), featureToSet.getValue(), service, request);
                if (command == null) continue;
                resultCommand = resultCommand == null ? command : resultCommand.compose((IUndoableOperation)command);
            }
        }
        if (resultCommand != null) {
            return resultCommand.reduce();
        }
        return super.getAfterConfigureCommand(request);
    }

    protected ICommand getSetStereotypeFeatureValueCommand(Element elementToConfigure, Stereotype stereotype, String name, FeatureValue featureValue, IElementEditService service, ConfigureRequest configureRequest) {
        if (name == null) {
            Activator.log.debug("No feature name has been set.");
            return null;
        }
        if (elementToConfigure.eClass() == null) {
            Activator.log.error(NLS.bind((String)"Impossible to find EClass from EObject: {0}.", (Object)elementToConfigure), null);
            return null;
        }
        if (configureRequest.getEditingDomain() == null) {
            return null;
        }
        TypedElement typedElement = (TypedElement)stereotype.getMember(name, true, UMLPackage.eINSTANCE.getTypedElement());
        if (typedElement == null) {
            Activator.log.error(NLS.bind((String)"Impossible to find feature {0} for eobject {1}.", (Object)name, (Object)elementToConfigure), null);
            return null;
        }
        Object value = this.getStereotypeValue(elementToConfigure, stereotype, typedElement.getType(), featureValue);
        return service.getEditCommand((IEditCommandRequest)new SetStereotypeValueRequest(configureRequest.getEditingDomain(), stereotype, elementToConfigure, name, value));
    }

    protected Object getStereotypeValue(Element elementToConfigure, Stereotype stereotype, Type type, FeatureValue featureValue) {
        return StereotypeFeatureValueUtils.getValue((EObject)elementToConfigure, stereotype, type, featureValue);
    }
}

