/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.deployment.providers;

import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.gmf.runtime.emf.type.core.ElementTypeRegistry;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.DiagramElementTypes;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.providers.DiagramElementTypeImages;
import org.eclipse.papyrus.uml.diagram.deployment.part.UMLDiagramEditorPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLElementTypes {
    private static Map<IElementType, ENamedElement> elements;
    private static DiagramElementTypeImages elementTypeImages;
    private static Set<IElementType> KNOWN_ELEMENT_TYPES;
    public static final IElementType Package_DeploymentDiagram;
    public static final IElementType Dependency_Shape;
    public static final IElementType Model_Shape;
    public static final IElementType Package_Shape;
    public static final IElementType Constraint_Shape;
    public static final IElementType Comment_Shape;
    public static final IElementType ExecutionEnvironment_Shape;
    public static final IElementType Device_Shape;
    public static final IElementType Artifact_Shape;
    public static final IElementType Node_Shape;
    public static final IElementType NamedElement_DefaultShape;
    public static final IElementType DeploymentSpecification_Shape;
    public static final IElementType Model_Shape_CN;
    public static final IElementType Package_Shape_CN;
    public static final IElementType Device_Shape_CCN;
    public static final IElementType Device_Shape_CN;
    public static final IElementType ExecutionEnvironment_Shape_CCN;
    public static final IElementType ExecutionEnvironment_Shape_CN;
    public static final IElementType Node_Shape_CCN;
    public static final IElementType Node_Shape_CN;
    public static final IElementType Artifact_Shape_CCN;
    public static final IElementType Artifact_Shape_ACN;
    public static final IElementType Artifact_Shape_CN;
    public static final IElementType Comment_Shape_CN;
    public static final IElementType Constraint_Shape_CN;
    public static final IElementType DeploymentSpecification_Shape_CCN;
    public static final IElementType DeploymentSpecification_Shape_CN;
    public static final IElementType DeploymentSpecification_Shape_ACN;
    public static final IElementType Link_DescriptorEdge;
    public static final IElementType Comment_AnnotatedElementEdge;
    public static final IElementType Constraint_ConstrainedElementEdge;
    public static final IElementType Deployment_Edge;
    public static final IElementType Manifestation_Edge;
    public static final IElementType Generalization_Edge;
    public static final IElementType Dependency_Edge;
    public static final IElementType Dependency_BranchEdge;
    public static final IElementType CommunicationPath_Edge;
    public static final DiagramElementTypes TYPED_INSTANCE;

    static {
        elementTypeImages = new DiagramElementTypeImages(UMLDiagramEditorPlugin.getInstance().getItemProvidersAdapterFactory());
        Package_DeploymentDiagram = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Package_DeploymentDiagram");
        Dependency_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Dependency_Shape");
        Model_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Model_Shape");
        Package_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Package_Shape");
        Constraint_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Constraint_Shape");
        Comment_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Comment_Shape");
        ExecutionEnvironment_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.ExecutionEnvironment_Shape");
        Device_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Device_Shape");
        Artifact_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Artifact_Shape");
        Node_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Node_Shape");
        NamedElement_DefaultShape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.NamedElement_DefaultShape");
        DeploymentSpecification_Shape = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.DeploymentSpecification_Shape");
        Model_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Model_Shape_CN");
        Package_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Package_Shape_CN");
        Device_Shape_CCN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Device_Shape_CCN");
        Device_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Device_Shape_CN");
        ExecutionEnvironment_Shape_CCN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.ExecutionEnvironment_Shape_CCN");
        ExecutionEnvironment_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.ExecutionEnvironment_Shape_CN");
        Node_Shape_CCN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Node_Shape_CCN");
        Node_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Node_Shape_CN");
        Artifact_Shape_CCN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Artifact_Shape_CCN");
        Artifact_Shape_ACN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Artifact_Shape_ACN");
        Artifact_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Artifact_Shape_CN");
        Comment_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Comment_Shape_CN");
        Constraint_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Constraint_Shape_CN");
        DeploymentSpecification_Shape_CCN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.DeploymentSpecification_Shape_CCN");
        DeploymentSpecification_Shape_CN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.DeploymentSpecification_Shape_CN");
        DeploymentSpecification_Shape_ACN = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.DeploymentSpecification_Shape_ACN");
        Link_DescriptorEdge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Link_DescriptorEdge");
        Comment_AnnotatedElementEdge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Comment_AnnotatedElementEdge");
        Constraint_ConstrainedElementEdge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Constraint_ConstrainedElementEdge");
        Deployment_Edge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Deployment_Edge");
        Manifestation_Edge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Manifestation_Edge");
        Generalization_Edge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Generalization_Edge");
        Dependency_Edge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Dependency_Edge");
        Dependency_BranchEdge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.Dependency_BranchEdge");
        CommunicationPath_Edge = UMLElementTypes.getElementTypeByUniqueId("org.eclipse.papyrus.umldi.CommunicationPath_Edge");
        TYPED_INSTANCE = new DiagramElementTypes(elementTypeImages){

            public boolean isKnownElementType(IElementType elementType) {
                return UMLElementTypes.isKnownElementType(elementType);
            }

            public IElementType getElementTypeForVisualId(String visualID) {
                return UMLElementTypes.getElementType(visualID);
            }

            public ENamedElement getDefiningNamedElement(IAdaptable elementTypeAdapter) {
                return UMLElementTypes.getElement(elementTypeAdapter);
            }
        };
    }

    private UMLElementTypes() {
    }

    public static ImageDescriptor getImageDescriptor(ENamedElement element) {
        return elementTypeImages.getImageDescriptor(element);
    }

    public static Image getImage(ENamedElement element) {
        return elementTypeImages.getImage(element);
    }

    public static ImageDescriptor getImageDescriptor(IAdaptable hint) {
        return UMLElementTypes.getImageDescriptor(UMLElementTypes.getElement(hint));
    }

    public static Image getImage(IAdaptable hint) {
        return UMLElementTypes.getImage(UMLElementTypes.getElement(hint));
    }

    public static synchronized ENamedElement getElement(IAdaptable hint) {
        Object type = hint.getAdapter(IElementType.class);
        if (elements == null) {
            elements = new IdentityHashMap<IElementType, ENamedElement>();
            elements.put(Package_DeploymentDiagram, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Dependency_Shape, (ENamedElement)UMLPackage.eINSTANCE.getDependency());
            elements.put(Model_Shape, (ENamedElement)UMLPackage.eINSTANCE.getModel());
            elements.put(Package_Shape, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Constraint_Shape, (ENamedElement)UMLPackage.eINSTANCE.getConstraint());
            elements.put(Comment_Shape, (ENamedElement)UMLPackage.eINSTANCE.getComment());
            elements.put(ExecutionEnvironment_Shape, (ENamedElement)UMLPackage.eINSTANCE.getExecutionEnvironment());
            elements.put(Device_Shape, (ENamedElement)UMLPackage.eINSTANCE.getDevice());
            elements.put(Artifact_Shape, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(Node_Shape, (ENamedElement)UMLPackage.eINSTANCE.getNode());
            elements.put(NamedElement_DefaultShape, (ENamedElement)UMLPackage.eINSTANCE.getNamedElement());
            elements.put(DeploymentSpecification_Shape, (ENamedElement)UMLPackage.eINSTANCE.getDeploymentSpecification());
            elements.put(Model_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getModel());
            elements.put(Package_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getPackage());
            elements.put(Device_Shape_CCN, (ENamedElement)UMLPackage.eINSTANCE.getDevice());
            elements.put(Device_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getDevice());
            elements.put(ExecutionEnvironment_Shape_CCN, (ENamedElement)UMLPackage.eINSTANCE.getExecutionEnvironment());
            elements.put(ExecutionEnvironment_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getExecutionEnvironment());
            elements.put(Node_Shape_CCN, (ENamedElement)UMLPackage.eINSTANCE.getNode());
            elements.put(Node_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getNode());
            elements.put(Artifact_Shape_CCN, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(Artifact_Shape_ACN, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(Artifact_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getArtifact());
            elements.put(Comment_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getComment());
            elements.put(Constraint_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getConstraint());
            elements.put(DeploymentSpecification_Shape_CCN, (ENamedElement)UMLPackage.eINSTANCE.getDeploymentSpecification());
            elements.put(DeploymentSpecification_Shape_CN, (ENamedElement)UMLPackage.eINSTANCE.getDeploymentSpecification());
            elements.put(DeploymentSpecification_Shape_ACN, (ENamedElement)UMLPackage.eINSTANCE.getDeploymentSpecification());
            elements.put(Comment_AnnotatedElementEdge, (ENamedElement)UMLPackage.eINSTANCE.getComment_AnnotatedElement());
            elements.put(Constraint_ConstrainedElementEdge, (ENamedElement)UMLPackage.eINSTANCE.getConstraint_ConstrainedElement());
            elements.put(Deployment_Edge, (ENamedElement)UMLPackage.eINSTANCE.getDeployment());
            elements.put(Manifestation_Edge, (ENamedElement)UMLPackage.eINSTANCE.getManifestation());
            elements.put(Generalization_Edge, (ENamedElement)UMLPackage.eINSTANCE.getGeneralization());
            elements.put(Dependency_Edge, (ENamedElement)UMLPackage.eINSTANCE.getDependency());
            elements.put(Dependency_BranchEdge, (ENamedElement)UMLPackage.eINSTANCE.getDependency());
            elements.put(CommunicationPath_Edge, (ENamedElement)UMLPackage.eINSTANCE.getCommunicationPath());
        }
        return elements.get(type);
    }

    private static IElementType getElementTypeByUniqueId(String id) {
        return ElementTypeRegistry.getInstance().getType(id);
    }

    public static synchronized boolean isKnownElementType(IElementType elementType) {
        boolean result;
        if (KNOWN_ELEMENT_TYPES == null) {
            KNOWN_ELEMENT_TYPES = new HashSet<IElementType>();
            KNOWN_ELEMENT_TYPES.add(Package_DeploymentDiagram);
            KNOWN_ELEMENT_TYPES.add(Dependency_Shape);
            KNOWN_ELEMENT_TYPES.add(Model_Shape);
            KNOWN_ELEMENT_TYPES.add(Package_Shape);
            KNOWN_ELEMENT_TYPES.add(Constraint_Shape);
            KNOWN_ELEMENT_TYPES.add(Comment_Shape);
            KNOWN_ELEMENT_TYPES.add(ExecutionEnvironment_Shape);
            KNOWN_ELEMENT_TYPES.add(Device_Shape);
            KNOWN_ELEMENT_TYPES.add(Artifact_Shape);
            KNOWN_ELEMENT_TYPES.add(Node_Shape);
            KNOWN_ELEMENT_TYPES.add(NamedElement_DefaultShape);
            KNOWN_ELEMENT_TYPES.add(DeploymentSpecification_Shape);
            KNOWN_ELEMENT_TYPES.add(Model_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(Package_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(Device_Shape_CCN);
            KNOWN_ELEMENT_TYPES.add(Device_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(ExecutionEnvironment_Shape_CCN);
            KNOWN_ELEMENT_TYPES.add(ExecutionEnvironment_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(Node_Shape_CCN);
            KNOWN_ELEMENT_TYPES.add(Node_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(Artifact_Shape_CCN);
            KNOWN_ELEMENT_TYPES.add(Artifact_Shape_ACN);
            KNOWN_ELEMENT_TYPES.add(Artifact_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(Comment_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(Constraint_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(DeploymentSpecification_Shape_CCN);
            KNOWN_ELEMENT_TYPES.add(DeploymentSpecification_Shape_CN);
            KNOWN_ELEMENT_TYPES.add(DeploymentSpecification_Shape_ACN);
            KNOWN_ELEMENT_TYPES.add(Link_DescriptorEdge);
            KNOWN_ELEMENT_TYPES.add(Comment_AnnotatedElementEdge);
            KNOWN_ELEMENT_TYPES.add(Constraint_ConstrainedElementEdge);
            KNOWN_ELEMENT_TYPES.add(Deployment_Edge);
            KNOWN_ELEMENT_TYPES.add(Manifestation_Edge);
            KNOWN_ELEMENT_TYPES.add(Generalization_Edge);
            KNOWN_ELEMENT_TYPES.add(Dependency_Edge);
            KNOWN_ELEMENT_TYPES.add(Dependency_BranchEdge);
            KNOWN_ELEMENT_TYPES.add(CommunicationPath_Edge);
        }
        if (!(result = KNOWN_ELEMENT_TYPES.contains(elementType))) {
            IElementType[] supertypes = elementType.getAllSuperTypes();
            int i = 0;
            while (!result && i < supertypes.length) {
                result = KNOWN_ELEMENT_TYPES.contains(supertypes[i]);
                ++i;
            }
        }
        return result;
    }

    public static IElementType getElementType(String visualID) {
        block115: {
            if (visualID == null) break block115;
            switch (visualID) {
                case "Package_DeploymentDiagram": {
                    return Package_DeploymentDiagram;
                }
                case "Dependency_Shape": {
                    return Dependency_Shape;
                }
                case "Model_Shape": {
                    return Model_Shape;
                }
                case "Package_Shape": {
                    return Package_Shape;
                }
                case "Constraint_Shape": {
                    return Constraint_Shape;
                }
                case "Comment_Shape": {
                    return Comment_Shape;
                }
                case "ExecutionEnvironment_Shape": {
                    return ExecutionEnvironment_Shape;
                }
                case "Device_Shape": {
                    return Device_Shape;
                }
                case "Artifact_Shape": {
                    return Artifact_Shape;
                }
                case "Node_Shape": {
                    return Node_Shape;
                }
                case "NamedElement_DefaultShape": {
                    return NamedElement_DefaultShape;
                }
                case "DeploymentSpecification_Shape": {
                    return DeploymentSpecification_Shape;
                }
                case "Model_Shape_CN": {
                    return Model_Shape_CN;
                }
                case "Package_Shape_CN": {
                    return Package_Shape_CN;
                }
                case "Device_Shape_CCN": {
                    return Device_Shape_CCN;
                }
                case "Device_Shape_CN": {
                    return Device_Shape_CN;
                }
                case "ExecutionEnvironment_Shape_CCN": {
                    return ExecutionEnvironment_Shape_CCN;
                }
                case "ExecutionEnvironment_Shape_CN": {
                    return ExecutionEnvironment_Shape_CN;
                }
                case "Node_Shape_CCN": {
                    return Node_Shape_CCN;
                }
                case "Node_Shape_CN": {
                    return Node_Shape_CN;
                }
                case "Artifact_Shape_CCN": {
                    return Artifact_Shape_CCN;
                }
                case "Artifact_Shape_ACN": {
                    return Artifact_Shape_ACN;
                }
                case "Artifact_Shape_CN": {
                    return Artifact_Shape_CN;
                }
                case "Comment_Shape_CN": {
                    return Comment_Shape_CN;
                }
                case "Constraint_Shape_CN": {
                    return Constraint_Shape_CN;
                }
                case "DeploymentSpecification_Shape_CCN": {
                    return DeploymentSpecification_Shape_CCN;
                }
                case "DeploymentSpecification_Shape_CN": {
                    return DeploymentSpecification_Shape_CN;
                }
                case "DeploymentSpecification_Shape_ACN": {
                    return DeploymentSpecification_Shape_ACN;
                }
                case "Link_DescriptorEdge": {
                    return Link_DescriptorEdge;
                }
                case "Comment_AnnotatedElementEdge": {
                    return Comment_AnnotatedElementEdge;
                }
                case "Constraint_ConstrainedElementEdge": {
                    return Constraint_ConstrainedElementEdge;
                }
                case "Deployment_Edge": {
                    return Deployment_Edge;
                }
                case "Manifestation_Edge": {
                    return Manifestation_Edge;
                }
                case "Generalization_Edge": {
                    return Generalization_Edge;
                }
                case "Dependency_Edge": {
                    return Dependency_Edge;
                }
                case "Dependency_BranchEdge": {
                    return Dependency_BranchEdge;
                }
                case "CommunicationPath_Edge": {
                    return CommunicationPath_Edge;
                }
            }
        }
        return null;
    }

    public static boolean isKindOf(IElementType subtype, IElementType supertype) {
        boolean result;
        boolean bl = result = subtype == supertype;
        if (!result) {
            IElementType[] supertypes = subtype.getAllSuperTypes();
            int i = 0;
            while (!result && i < supertypes.length) {
                result = supertype == supertypes[i];
                ++i;
            }
        }
        return result;
    }
}

