/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.navigation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.infra.gmfdiag.navigation.ExistingNavigableElement;
import org.eclipse.papyrus.infra.gmfdiag.navigation.IModelLinker;
import org.eclipse.papyrus.infra.gmfdiag.navigation.INavigationRule;
import org.eclipse.papyrus.infra.gmfdiag.navigation.NavigableElement;
import org.eclipse.papyrus.uml.diagram.navigation.UMLRuleHelper;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallBehaviorAction;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.UMLPackage;

public class CBARule
implements INavigationRule {
    public boolean handle(EObject element) {
        return element instanceof CallBehaviorAction;
    }

    public List<NavigableElement> getNextPossibleElements(NavigableElement currentNavElement) {
        LinkedList<NavigableElement> nextPossibleElements = new LinkedList<NavigableElement>();
        EReference feature = UMLPackage.Literals.CALL_BEHAVIOR_ACTION__BEHAVIOR;
        final CallBehaviorAction cba = (CallBehaviorAction)currentNavElement.getElement();
        if (cba.getBehavior() != null) {
            nextPossibleElements.add((NavigableElement)new ExistingNavigableElement((EObject)cba.getBehavior(), (EStructuralFeature)feature));
        } else {
            UMLRuleHelper.addBehaviorCreatedNavigableElements(nextPossibleElements, currentNavElement, (EStructuralFeature)feature, new IModelLinker(){

                public void linkToModel(EObject toLink) {
                    Package owner = cba.getActivity().getNearestPackage();
                    owner.getPackagedElements().add((Object)((PackageableElement)toLink));
                    cba.setBehavior((Behavior)toLink);
                }
            });
        }
        return nextPossibleElements;
    }
}

