/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.engine;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.css.core.dom.IElementProvider;
import org.eclipse.e4.ui.css.core.engine.CSSElementContext;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.IRefreshHandlerPart;
import org.eclipse.papyrus.infra.gmfdiag.common.handler.RefreshHandler;
import org.eclipse.papyrus.infra.gmfdiag.css.Activator;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngine;
import org.eclipse.papyrus.infra.gmfdiag.css.engine.ExtendedCSSEngineImpl;
import org.eclipse.ui.IEditorPart;
import org.w3c.dom.Element;

public class BaseCSSEngine
extends ExtendedCSSEngineImpl
implements IRefreshHandlerPart {
    public static final String EXTENSION_ID = "org.eclipse.papyrus.infra.gmfdiag.css.userAgentStyleSheet";
    public static final ExtendedCSSEngine INSTANCE = new BaseCSSEngine();

    private BaseCSSEngine() {
        RefreshHandler.register((IRefreshHandlerPart)this);
        try {
            this.styleSheetURLs.add(new URL("platform:/plugin/org.eclipse.papyrus.infra.gmfdiag.css/resources/base.css"));
            this.loadCSSContributions();
        }
        catch (MalformedURLException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    public void refresh(IEditorPart editorPart) {
        this.reset();
    }

    @Override
    public Element getElement(Object node) {
        throw new UnsupportedOperationException();
    }

    public IElementProvider getElementProvider() {
        throw new UnsupportedOperationException();
    }

    public void setElementProvider(IElementProvider elementProvider) {
        throw new UnsupportedOperationException();
    }

    public CSSElementContext getCSSElementContext(Object node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExtendedCSSEngine.CascadeScope getCascadeScope() {
        return ExtendedCSSEngine.CascadeScope.USER_AGENT;
    }

    private void loadCSSContributions() {
        IConfigurationElement[] config;
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement cssConfig = iConfigurationElementArray[n2];
            String path = cssConfig.getAttribute("stylesheetPath");
            try {
                URL url = new URL("platform:/plugin/" + cssConfig.getContributor().getName() + "/" + path);
                this.styleSheetURLs.add(url);
            }
            catch (IOException ex) {
                Activator.log.error((Throwable)ex);
            }
            ++n2;
        }
    }
}

