/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.dnd;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gmf.runtime.notation.EObjectListValueStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.commands.wrappers.EMFtoGEFCommandWrapper;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.gmfdiag.common.helper.NotationHelper;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddCSSStyleSheetCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StyleSheetReference;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.StylesheetsFactory;
import org.eclipse.papyrus.infra.gmfdiag.dnd.strategy.TransactionalDropStrategy;
import org.eclipse.swt.graphics.Image;

public class StyleSheetDropStrategy
extends TransactionalDropStrategy {
    public static final String ID = "org.eclipse.papyrus.infra.gmfdiag.css.properties.drop";

    public String getLabel() {
        return "Add Stylesheet Reference";
    }

    public String getDescription() {
        return "Adds a stylesheet to the diagram by reference to the dropped CSS resource";
    }

    public Image getImage() {
        return null;
    }

    public String getID() {
        return ID;
    }

    public int getPriority() {
        return 0;
    }

    protected org.eclipse.gef.commands.Command doGetCommand(Request request, EditPart targetEditPart) {
        org.eclipse.gef.commands.Command result = null;
        View targetView = NotationHelper.findView((Object)targetEditPart);
        Object object = targetView = targetView != null ? targetView.getDiagram() : targetView;
        if (targetView != null) {
            ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
            List objects = selection instanceof IStructuredSelection ? ((IStructuredSelection)selection).toList() : Collections.emptyList();
            EObjectListValueStyle existingReferences = (EObjectListValueStyle)targetView.getNamedStyle(NotationPackage.Literals.EOBJECT_LIST_VALUE_STYLE, "css_stylesheets");
            ArrayList cssPaths = Lists.newArrayListWithCapacity((int)objects.size());
            for (Object next : objects) {
                IFile file = (IFile)AdapterUtils.adapt(next, IFile.class, null);
                if (file != null && "css".equals(file.getFileExtension())) {
                    String path = file.getFullPath().toString();
                    boolean found = false;
                    if (existingReferences != null) {
                        for (StyleSheetReference ref : Iterables.filter((Iterable)existingReferences.getEObjectListValue(), StyleSheetReference.class)) {
                            if (!path.equals(ref.getPath())) continue;
                            found = true;
                            break;
                        }
                    }
                    if (found) continue;
                    cssPaths.add(path);
                    continue;
                }
                cssPaths.clear();
                break;
            }
            if (!cssPaths.isEmpty()) {
                CompoundCommand compound = new CompoundCommand(this.getLabel());
                TransactionalEditingDomain domain = this.getTransactionalEditingDomain(targetEditPart);
                for (String next : cssPaths) {
                    StyleSheetReference ref = StylesheetsFactory.eINSTANCE.createStyleSheetReference();
                    ref.setPath(next);
                    AddCSSStyleSheetCommand command = new AddCSSStyleSheetCommand((EditingDomain)domain, targetView, "css_stylesheets", NotationPackage.Literals.EOBJECT_LIST_VALUE_STYLE, (EStructuralFeature)NotationPackage.Literals.EOBJECT_LIST_VALUE_STYLE__EOBJECT_LIST_VALUE, ref){

                        public String getLabel() {
                            return StyleSheetDropStrategy.this.getLabel();
                        }
                    };
                    compound.add(EMFtoGEFCommandWrapper.wrap((Command)command));
                }
                result = compound.unwrap();
            }
        }
        return result;
    }
}

