/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.localizer.util;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResource;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.services.localizer.DefaultObjectLocalizer;
import org.eclipse.papyrus.infra.services.localizer.IObjectLocalizer;
import org.eclipse.papyrus.infra.services.localizer.internal.Activator;

public class LocalizerUtil {
    private LocalizerUtil() {
    }

    public static IObjectLocalizer getDefault() {
        return DefaultObjectLocalizer.INSTANCE;
    }

    public static IObjectLocalizer getInstance(ResourceSet rset) {
        try {
            return LocalizerUtil.getInstance(ServiceUtilsForResourceSet.getInstance().getServiceRegistry(rset));
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to get localizer service.", (Throwable)e);
            return LocalizerUtil.getDefault();
        }
    }

    public static IObjectLocalizer getInstance(Resource resource) {
        try {
            return LocalizerUtil.getInstance(ServiceUtilsForResource.getInstance().getServiceRegistry(resource));
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to get localizer service.", (Throwable)e);
            return LocalizerUtil.getDefault();
        }
    }

    public static IObjectLocalizer getInstance(EObject object) {
        try {
            return LocalizerUtil.getInstance(ServiceUtilsForEObject.getInstance().getServiceRegistry(object));
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to get localizer service.", (Throwable)e);
            return LocalizerUtil.getDefault();
        }
    }

    public static IObjectLocalizer getInstance(ServicesRegistry services) {
        try {
            return (IObjectLocalizer)services.getService(IObjectLocalizer.class);
        }
        catch (ServiceException e) {
            Activator.log.error("Failed to get localizer service.", (Throwable)e);
            return LocalizerUtil.getDefault();
        }
    }
}

