/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.types.core.notification;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.papyrus.infra.types.core.notification.ITypesEventsChainListener;
import org.eclipse.papyrus.infra.types.core.notification.ITypesEventsListener;
import org.eclipse.papyrus.infra.types.core.notification.TypesEventsChain;
import org.eclipse.papyrus.infra.types.core.notification.events.ITypesEvent;

public class TypesListenersRegistry {
    private static Set<ITypesEventsChainListener> eventChainListeners = null;
    private static Set<ITypesEventsListener> eventListeners = null;
    private static TypesListenersRegistry instance = null;

    private TypesListenersRegistry() {
    }

    public static synchronized TypesListenersRegistry getInstance() {
        if (instance == null) {
            instance = new TypesListenersRegistry();
            TypesListenersRegistry.init();
        }
        return instance;
    }

    public static void init() {
        eventChainListeners = new HashSet<ITypesEventsChainListener>();
        eventListeners = new HashSet<ITypesEventsListener>();
    }

    public void addEventChainListener(ITypesEventsChainListener listener) {
        eventChainListeners.add(listener);
    }

    public void removeEventChainListener(ITypesEventsChainListener listener) {
        eventChainListeners.remove(listener);
    }

    public void addEventListener(ITypesEventsListener listener) {
        eventListeners.add(listener);
    }

    public void removeEventChainListener(ITypesEventsListener listener) {
        eventListeners.remove(listener);
    }

    public void notifyChain(TypesEventsChain chain) {
        for (ITypesEventsChainListener eventsChainListener : eventChainListeners) {
            eventsChainListener.notifyChain(chain);
        }
    }

    public void notifyEvent(ITypesEvent event) {
        for (ITypesEventsListener eventsListener : eventListeners) {
            eventsListener.notifyEvent(event);
        }
    }
}

