/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.helper;

import java.util.Collection;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.helper.PropertyLabelHelper;
import org.eclipse.papyrus.uml.tools.utils.PortUtil;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;

public class PortLabelHelper
extends PropertyLabelHelper {
    private static PortLabelHelper labelHelper;

    public static PortLabelHelper getInstance() {
        if (labelHelper == null) {
            labelHelper = new PortLabelHelper();
        }
        return labelHelper;
    }

    protected PortLabelHelper() {
        this.masks.put("conjugated", "Conjugated");
    }

    @Override
    protected String parseString(GraphicalEditPart editPart, Collection<String> maskValues) {
        Port port = this.getUMLElement(editPart);
        if (port != null) {
            return PortUtil.getCustomLabel((Property)port, maskValues);
        }
        return "";
    }

    public Port getUMLElement(GraphicalEditPart editPart) {
        View view;
        if (editPart.getModel() instanceof View && (view = (View)editPart.getModel()).getElement() instanceof Port) {
            return (Port)view.getElement();
        }
        return null;
    }
}

