/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.menu.handlers;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.infra.core.clipboard.PapyrusClipboard;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.AbstractGraphicalCommandHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.handlers.CopyInDiagramHandler;
import org.eclipse.papyrus.infra.gmfdiag.menu.utils.DeleteActionUtil;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CutInDiagramHandler
extends AbstractGraphicalCommandHandler {
    private static final String DELETE_COMMAND_LABEL = "Delete From Model";
    private static final String CUT_COMMAND_LABEL = "Cut In Diagram Command";
    private Object activeFocusControl;
    private Object activeShell;

    @Override
    protected Command getCommand() {
        CompoundCommand cutInDiagramCommand = new CompoundCommand(CUT_COMMAND_LABEL);
        Command buildCopy = CopyInDiagramHandler.buildCopyCommand(this.getEditingDomain(), this.getSelectedElements());
        cutInDiagramCommand.add(buildCopy);
        Command buildDelete = this.buildDeleteCommand();
        cutInDiagramCommand.add(buildDelete);
        return cutInDiagramCommand;
    }

    protected Command buildDeleteCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        if (editingDomain == null) {
            return UnexecutableCommand.INSTANCE;
        }
        List<IGraphicalEditPart> editParts = this.getSelectedElements();
        if (editParts.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompositeTransactionalCommand command = new CompositeTransactionalCommand(editingDomain, DELETE_COMMAND_LABEL);
        for (IGraphicalEditPart editPart : editParts) {
            if (editPart instanceof DiagramEditPart) continue;
            Command curCommand = null;
            curCommand = DeleteActionUtil.isSemanticDeletion(editPart) ? editPart.getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new DestroyElementRequest(false))) : DeleteActionUtil.getDeleteFromDiagramCommand(editPart);
            if (curCommand == null) continue;
            command.compose((IUndoableOperation)new CommandProxy(curCommand));
        }
        if (command.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ICommandProxy((ICommand)command);
    }

    @Override
    public void setEnabled(Object evaluationContext) {
        if (evaluationContext instanceof IEvaluationContext) {
            IEvaluationContext iEvaluationContext = (IEvaluationContext)evaluationContext;
            this.activeFocusControl = iEvaluationContext.getVariable("activeFocusControl");
            this.activeShell = iEvaluationContext.getVariable("activeShell");
        }
        super.setEnabled(evaluationContext);
    }

    @Override
    protected boolean computeEnabled() {
        Shell shell;
        Display display;
        boolean isEnabled = false;
        Control focusControl = null;
        if (this.activeShell instanceof Shell && (display = (shell = (Shell)this.activeShell).getDisplay()) != null) {
            focusControl = display.getFocusControl();
        }
        if (!(this.activeFocusControl instanceof StyledText) && !(focusControl instanceof Text)) {
            PapyrusClipboard instance = PapyrusClipboard.getInstance();
            PapyrusClipboard.setInstance((PapyrusClipboard)instance);
            isEnabled = true;
        }
        return isEnabled;
    }
}

