/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.edit.CheckBoxStateEnum;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class TreeCheckBoxPainter
extends ImagePainter {
    private final Image checkedImg;
    private final Image semicheckedImg;
    private final Image uncheckedImg;

    public TreeCheckBoxPainter() {
        this(GUIHelper.getImage("checked"), GUIHelper.getImage("semichecked"), GUIHelper.getImage("unchecked"));
    }

    public TreeCheckBoxPainter(Image checkedImg, Image semicheckedImage, Image uncheckedImg) {
        this.checkedImg = checkedImg;
        this.semicheckedImg = semicheckedImage;
        this.uncheckedImg = uncheckedImg;
    }

    public int getPreferredWidth(boolean checked) {
        return this.getImage((boolean)checked).getBounds().width;
    }

    public int getPreferredHeight(boolean checked) {
        return this.getImage((boolean)checked).getBounds().height;
    }

    public void paintIconImage(GC gc, Rectangle rectangle, int yOffset, boolean checked) {
        Image checkBoxImage = this.getImage(checked);
        int x = rectangle.x + rectangle.width / 2 - checkBoxImage.getBounds().width / 2;
        gc.drawImage(checkBoxImage, x, rectangle.y + yOffset);
    }

    public Image getImage(boolean checked) {
        return checked ? this.checkedImg : this.uncheckedImg;
    }

    @Override
    protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
        Image result = null;
        switch (this.getCheckBoxState(cell)) {
            case CHECKED: {
                result = this.checkedImg;
                break;
            }
            case SEMICHECKED: {
                result = this.semicheckedImg;
                break;
            }
            default: {
                result = this.uncheckedImg;
            }
        }
        return result;
    }

    protected abstract CheckBoxStateEnum getCheckBoxState(ILayerCell var1);
}

