/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.resource;

import java.util.Objects;
import org.eclipse.core.internal.preferences.AbstractScope;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class PapyrusProjectScope
extends AbstractScope {
    public static final String SCOPE = "papyrusProject";
    private final String papyrusProjectName;
    private final IProject context;
    private int hash = 0;

    public PapyrusProjectScope(IProject project, String papyrusProjectName) {
        this.context = project;
        this.papyrusProjectName = papyrusProjectName;
    }

    public IEclipsePreferences getNode(String qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException();
        }
        StringBuilder node = new StringBuilder(this.context.getName());
        node.append("/");
        node.append(this.papyrusProjectName);
        return (IEclipsePreferences)Platform.getPreferencesService().getRootNode().node(SCOPE).node(node.toString()).node(qualifier);
    }

    public String getName() {
        return SCOPE;
    }

    public IPath getLocation() {
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PapyrusProjectScope)) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PapyrusProjectScope other = (PapyrusProjectScope)((Object)obj);
        return this.context.equals((Object)other.context) && this.papyrusProjectName.equals(other.papyrusProjectName);
    }

    public int hashCode() {
        if (this.hash == 0) {
            int h = super.hashCode();
            h = 37 * h + Objects.hashCode(this.context);
            this.hash = h = 37 * h + Objects.hashCode(this.papyrusProjectName);
        }
        return this.hash;
    }
}

