/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.listener;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.listenerservice.IPapyrusListener;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.NotFoundException;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.uml.tools.Activator;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.papyrus.uml.tools.profile.definition.PapyrusDefinitionAnnotation;
import org.eclipse.papyrus.uml.tools.service.IProfileDefinitionService;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.resource.UMLResource;

public class ProfileDefinitionTagListener
implements IPapyrusListener {
    private static final String MODEL_SET_SERVICE_ERROR = "Failed to get Model Set.";
    private static final String DECORATION_ACTION_ERROR = "Failed to decorate undefined Profile.";
    private static final String UNDECORATION_ACTION_ERROR = "Failed to remove decoration on Profile.";
    private static final String ROOT_MODEL_ACCESS_ERROR = "Failed to retrieve root element of UML resource";

    public void notifyChanged(Notification notification) {
        int eventType = notification.getEventType();
        Object notifier = notification.getNotifier();
        if (9 != eventType && 8 != eventType) {
            EObject rootElement;
            EAnnotation undefinedAnnotation;
            EAnnotation umlAnnotation;
            if (notifier instanceof Element) {
                EAnnotation umlAnnotation2;
                EObject rootElement2;
                Resource resource = ((Element)notifier).eResource();
                if (resource instanceof UMLResource && (rootElement2 = this.getRootModel((EObject)notifier)) instanceof Profile && (umlAnnotation2 = ((Profile)rootElement2).getEAnnotation("http://www.eclipse.org/uml2/2.0.0/UML")) != null && !this.isAlreadyTag(umlAnnotation2)) {
                    umlAnnotation2.getEAnnotations().add((Object)PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION.convertToEAnnotation());
                    this.decorateProfile((Profile)rootElement2);
                }
            } else if (3 == eventType && notifier instanceof EAnnotation && notification.getNewValue() instanceof EAnnotation) {
                EObject rootElement3;
                EAnnotation umlAnnotation3 = (EAnnotation)notifier;
                EAnnotation undefinedAnnotation2 = (EAnnotation)notification.getNewValue();
                if (this.isUndefinedProfileTagAnnotation(umlAnnotation3, undefinedAnnotation2) && (rootElement3 = this.getRootModel((EObject)umlAnnotation3)) instanceof Profile) {
                    this.decorateProfile((Profile)rootElement3);
                }
            } else if (4 == eventType && notifier instanceof EAnnotation && notification.getOldValue() instanceof EAnnotation && this.isUndefinedProfileTagAnnotation(umlAnnotation = (EAnnotation)notifier, undefinedAnnotation = (EAnnotation)notification.getOldValue()) && (rootElement = this.getRootModel((EObject)umlAnnotation)) instanceof Profile) {
                this.undecorateProfile((Profile)rootElement);
            }
        }
    }

    private boolean isUndefinedProfileTagAnnotation(EAnnotation umlAnnotation, EAnnotation undefinedAnnotation) {
        Resource resource = umlAnnotation.eResource();
        PapyrusDefinitionAnnotation parsedAnnotation = PapyrusDefinitionAnnotation.parseEAnnotation((EAnnotation)undefinedAnnotation);
        return "PapyrusVersion".equals(undefinedAnnotation.getSource()) && PapyrusDefinitionAnnotation.UNDEFINED_ANNOTATION.equals(parsedAnnotation) && resource instanceof UMLResource;
    }

    private EObject getRootModel(EObject element) {
        EObject rootElement = null;
        try {
            ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)element);
            UmlModel umlModel = (UmlModel)modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
            rootElement = umlModel.lookupRoot();
        }
        catch (ServiceException exception) {
            Activator.log.error(MODEL_SET_SERVICE_ERROR, (Throwable)exception);
        }
        catch (NotFoundException exception) {
            Activator.log.error(ROOT_MODEL_ACCESS_ERROR, (Throwable)exception);
        }
        return rootElement;
    }

    private void undecorateProfile(Profile profile) {
        try {
            DecorationService decorationService = (DecorationService)ServiceUtilsForEObject.getInstance().getService(DecorationService.class, (Object)profile);
            IProfileDefinitionService definitionService = (IProfileDefinitionService)ServiceUtilsForEObject.getInstance().getService(IProfileDefinitionService.class, (Object)profile);
            decorationService.removeDecoration(definitionService.getMarker(profile).toString());
            definitionService.disposeMarker(profile);
        }
        catch (ServiceException exception) {
            Activator.log.error(UNDECORATION_ACTION_ERROR, (Throwable)exception);
        }
    }

    private void decorateProfile(Profile profile) {
        try {
            ServiceUtilsForEObject serviceUtils = ServiceUtilsForEObject.getInstance();
            DecorationService decorationService = (DecorationService)serviceUtils.getService(DecorationService.class, (Object)profile);
            IProfileDefinitionService definitionService = (IProfileDefinitionService)serviceUtils.getService(IProfileDefinitionService.class, (Object)profile);
            decorationService.addDecoration(definitionService.getMarker(profile), (EObject)profile);
        }
        catch (ServiceException exception) {
            Activator.log.error(DECORATION_ACTION_ERROR, (Throwable)exception);
        }
    }

    private boolean isAlreadyTag(EAnnotation umlAnnotation) {
        boolean alreadyTag;
        boolean bl = alreadyTag = !umlAnnotation.getEAnnotations().isEmpty();
        if (alreadyTag) {
            EAnnotation firstAnnotation = umlAnnotation.getEAnnotation("PapyrusVersion");
            alreadyTag = firstAnnotation != null;
        }
        return alreadyTag;
    }
}

