/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.architecture.provider;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.papyrus.infra.core.architecture.provider.SurrogateItemPropertyDescriptor;

public class EPackagePropertyDescriptor
extends SurrogateItemPropertyDescriptor {
    public EPackagePropertyDescriptor(IItemPropertyDescriptor inner) {
        super(inner);
    }

    @Override
    public Collection<?> getChoiceOfValues(Object object) {
        UniqueEList.FastCompare result = new UniqueEList.FastCompare();
        EPackage.Registry reg = Optional.ofNullable(object).filter(EObject.class::isInstance).map(EObject.class::cast).map(EObject::eResource).map(Resource::getResourceSet).map(ResourceSet::getPackageRegistry).orElse(EPackage.Registry.INSTANCE);
        HashSet keys = new HashSet();
        keys.addAll(reg.keySet());
        if (reg != EPackage.Registry.INSTANCE) {
            keys.addAll(EPackage.Registry.INSTANCE.keySet());
        }
        for (String key : keys) {
            try {
                EPackage pack = reg.getEPackage(key);
                if (pack == null) continue;
                result.add(pack);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public IItemLabelProvider getLabelProvider(Object object) {
        return new IItemLabelProvider(){

            public String getText(Object object) {
                return ((EPackage)object).getNsURI();
            }

            public Object getImage(Object object) {
                return null;
            }
        };
    }
}

