/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.types.core.matchers.stereotype;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.papyrus.uml.types.core.Activator;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcher;
import org.eclipse.papyrus.uml.types.core.matchers.stereotype.StereotypeApplicationMatcherConfiguration;
import org.eclipse.papyrus.uml.types.core.requests.ApplyStereotypeRequest;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeMatcherEditHelperAdvice
extends AbstractEditHelperAdvice {
    protected StereotypeApplicationMatcherConfiguration configuration;

    public StereotypeMatcherEditHelperAdvice(StereotypeApplicationMatcherConfiguration configuration) {
        this.configuration = configuration;
    }

    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest getEditContext;
        IEditCommandRequest editRequest;
        CreateElementRequest createElement = null;
        if (request instanceof CreateElementRequest) {
            createElement = (CreateElementRequest)request;
        } else if (request instanceof GetEditContextRequest && (editRequest = (getEditContext = (GetEditContextRequest)request).getEditCommandRequest()) instanceof CreateElementRequest) {
            createElement = (CreateElementRequest)editRequest;
        }
        if (createElement != null) {
            if (this.configuration == null) {
                return false;
            }
            if (!(createElement.getContainer() instanceof Element)) {
                return false;
            }
            Element container = (Element)createElement.getContainer();
            Package nearestPackage = container.getNearestPackage();
            if (nearestPackage == null) {
                return false;
            }
            String profileURI = this.configuration.getProfileUri();
            if (profileURI != null && !StereotypeApplicationMatcher.isProfileApplied(container, profileURI)) {
                return false;
            }
            if (this.configuration.getStereotypesQualifiedNames().isEmpty() || !this.configuration.getStereotypesQualifiedNames().stream().allMatch(sqn -> this.isApplicableInContext((String)sqn, nearestPackage))) {
                return false;
            }
        }
        return true;
    }

    private boolean isApplicableInContext(String stereotypeQualifiedName, Package context) {
        int sep;
        int n = sep = stereotypeQualifiedName == null ? -1 : stereotypeQualifiedName.lastIndexOf("::");
        if (sep < 0) {
            return false;
        }
        String profileQualifiedName = stereotypeQualifiedName.substring(0, sep);
        String stereotypeName = stereotypeQualifiedName.substring(sep + "::".length());
        Profile profile = context.getAppliedProfile(profileQualifiedName);
        return profile != null && profile.getOwnedStereotype(stereotypeName) != null;
    }

    public void configureRequest(IEditCommandRequest request) {
        if (!(request instanceof ConfigureRequest)) {
            return;
        }
        EList<String> stereotypeQNames = this.configuration.getStereotypesQualifiedNames();
        if (!stereotypeQNames.isEmpty()) {
            request.setParameter("baseNameToSet", (Object)NamedElementUtil.getNameFromQualifiedName((String)((String)stereotypeQNames.get(stereotypeQNames.size() - 1))));
        }
    }

    protected ICommand getAfterConfigureCommand(ConfigureRequest request) {
        ICommand result = null;
        if (this.configuration == null) {
            return result;
        }
        EObject elementToConfigure = request.getElementToConfigure();
        if (!(elementToConfigure instanceof Element)) {
            return result;
        }
        TransactionalEditingDomain editingDomain = request.getEditingDomain();
        if (editingDomain == null) {
            return result;
        }
        IElementEditService service = ElementEditServiceUtils.getCommandProvider((EObject)elementToConfigure);
        if (service == null) {
            Activator.log.error(NLS.bind((String)"Cannot get edit service from element: {0}.", (Object)elementToConfigure), null);
            return result;
        }
        for (String next : this.configuration.getStereotypesQualifiedNames()) {
            Stereotype stereotype = ((Element)elementToConfigure).getApplicableStereotype(next);
            if (stereotype == null) continue;
            ICommand applyStereotypeCommand = service.getEditCommand((IEditCommandRequest)new ApplyStereotypeRequest((Element)elementToConfigure, stereotype, editingDomain));
            result = result == null ? applyStereotypeCommand : result.compose((IUndoableOperation)applyStereotypeCommand);
        }
        if (result != null) {
            result = result.reduce();
        }
        return result;
    }
}

