/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.properties.catalog;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.URIHandler;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.papyrus.infra.properties.catalog.PropertiesURIHandler;

public class PropertiesCatalog
implements Resource.Factory {
    public Resource createResource(URI sourceURI) {
        Resource.Factory delegate;
        PropertiesXMIResource result = null;
        PropertiesURIHandler handler = new PropertiesURIHandler();
        URI realURI = handler.getConvertedURI(sourceURI);
        if (!realURI.equals(sourceURI) && (delegate = Resource.Factory.Registry.INSTANCE.getFactory(realURI)) != null) {
            result = delegate.createResource(realURI);
            result.setURI(sourceURI);
            result.eAdapters().add((Object)new URIHandlerInstaller(handler));
        }
        if (result == null) {
            result = new PropertiesXMIResource(sourceURI);
        }
        return result;
    }

    public class PropertiesXMIResource
    extends XMIResourceImpl {
        public PropertiesXMIResource(URI sourceURI) {
            super(sourceURI);
        }

        public URIConverter getURIConverter() {
            return new ExtensibleURIConverterImpl(){

                public URIHandler getURIHandler(URI uri) {
                    return new PropertiesURIHandler();
                }
            };
        }
    }

    private static class URIHandlerInstaller
    extends AdapterImpl {
        private final URIHandler handler;

        URIHandlerInstaller(URIHandler handler) {
            this.handler = handler;
        }

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Resource && msg.getFeatureID(Resource.class) == 0 && msg.getNewValue() instanceof ResourceSet) {
                this.installURIHandler((ResourceSet)msg.getNewValue());
                ((Resource)msg.getNotifier()).eAdapters().remove((Object)this);
            }
        }

        void installURIHandler(ResourceSet resourceSet) {
            EList handlers = resourceSet.getURIConverter().getURIHandlers();
            if (!handlers.stream().anyMatch(PropertiesURIHandler.class::isInstance)) {
                handlers.add(Math.max(0, handlers.size() - 1), this.handler);
            }
        }
    }
}

