/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.providers;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.papyrus.infra.gmfdiag.common.providers.IGraphicalTypeRegistry;

public class GraphicalTypeRegistry
implements IGraphicalTypeRegistry {
    protected Set<String> knownNodes = new HashSet<String>();
    protected Set<String> knownEdges = new HashSet<String>();

    @Override
    public String getEdgeGraphicalType(EObject domainElement) {
        String graphicalType = "undefined_type";
        if (domainElement == null) {
            return "undefined_type";
        }
        return graphicalType;
    }

    @Override
    public String getEdgeGraphicalType(IElementType elementType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getEdgeGraphicalType(semanticHint);
        }
        return "undefined_type";
    }

    @Override
    public String getEdgeGraphicalType(String proposedType) {
        if (this.isKnownEdgeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    @Override
    public String getNodeGraphicalType(EObject domainElement, String containerType) {
        String graphicalType = "undefined_type";
        if (containerType == null || domainElement == null) {
            return "undefined_type";
        }
        return graphicalType;
    }

    @Override
    public String getNodeGraphicalType(IElementType elementType, String containerType) {
        if (elementType instanceof IHintedType) {
            String semanticHint = ((IHintedType)elementType).getSemanticHint();
            return this.getNodeGraphicalType(semanticHint, containerType);
        }
        return "undefined_type";
    }

    @Override
    public String getNodeGraphicalType(String proposedType, String containerType) {
        if (this.isKnownNodeType(proposedType)) {
            return proposedType;
        }
        return "undefined_type";
    }

    @Override
    public boolean isKnownEdgeType(String type) {
        return this.knownEdges.contains(type);
    }

    @Override
    public boolean isKnownNodeType(String type) {
        return this.knownNodes.contains(type);
    }
}

