/*****************************************************************************
 * Copyright (c) 2021 CEA LIST, ARTAL.
 *
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Etienne ALLOGO (Artal) etienne.allogo@artal.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.diagram.common.editparts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.IPapyrusEditPart;

/**
 * The class controls the behavior of a border item. It determines the
 * connections coming in and out.
 * It is a custom implementation of {@link org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart} with papyrus interface.
 *
 * @author allogo
 * @since 5.0
 *
 */
public abstract class AbstractBorderItemEditPart extends org.eclipse.gmf.runtime.diagram.ui.editparts.AbstractBorderItemEditPart implements IPapyrusEditPart {

	/**
	 * Constructor.
	 *
	 * @param view
	 */
	public AbstractBorderItemEditPart(View view) {
		super(view);
	}


	/**
	 *
	 * @return the figure that represent the shape, this class is generated by the GMF tooling
	 */
	protected abstract IFigure createNodePlate();

	/**
	 *
	 * @return the figure that represent the shape, this class is generated by the GMF tooling
	 */
	protected abstract IFigure createNodeShape();

	/**
	 * this method installs the content pane in the node shape to add compartment for example
	 *
	 * @param nodeShape
	 * @return the figure that is the the node shape
	 */
	protected abstract IFigure setupContentPane(IFigure nodeShape);

}
