/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.papyrus.infra.emf.gmf.command.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.gmf.command.INonDirtying;

public class OperationUtils {
    private OperationUtils() {
    }

    public static boolean anyDirtying(IUndoableOperation[] undoHistory) {
        boolean result = false;
        if (undoHistory != null && undoHistory.length > 0) {
            int i = 0;
            while (i < undoHistory.length) {
                if (!OperationUtils.isNonDirtying(undoHistory[i])) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public static boolean isNonDirtying(IUndoableOperation operation) {
        boolean result = operation instanceof INonDirtying;
        if (!result) {
            Command command = OperationUtils.unwrap(operation);
            result = command instanceof AbstractCommand.NonDirtying;
        }
        return result;
    }

    public static Command unwrap(IUndoableOperation operation) {
        Command result = null;
        if (operation instanceof EMFCommandOperation) {
            result = ((EMFCommandOperation)operation).getCommand();
        } else if (operation instanceof EMFtoGMFCommandWrapper) {
            result = ((EMFtoGMFCommandWrapper)operation).getWrappedCommand();
        }
        return result;
    }

    public static boolean isDirty(IUndoableOperation[] undoHistory, IUndoableOperation[] redoHistory, IUndoableOperation savepoint) {
        boolean result = false;
        if (savepoint == null) {
            result = OperationUtils.anyDirtying(undoHistory);
        } else {
            List redos;
            List undos = undoHistory == null || undoHistory.length == 0 ? Collections.emptyList() : Arrays.asList(undoHistory);
            List<Object> list = redos = redoHistory == null || redoHistory.length == 0 ? Collections.emptyList() : Arrays.asList(redoHistory);
            if (undos.contains(savepoint)) {
                int i = 0;
                while (i < undoHistory.length) {
                    if (undoHistory[i] == savepoint) {
                        ++i;
                        break;
                    }
                    ++i;
                }
                while (i < undoHistory.length) {
                    if (!OperationUtils.isNonDirtying(undoHistory[i])) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            } else if (redos.contains(savepoint)) {
                int i = redoHistory.length - 1;
                while (i >= 0) {
                    if (!OperationUtils.isNonDirtying(redoHistory[i])) {
                        result = true;
                    } else if (redoHistory[i] != savepoint) {
                        --i;
                        continue;
                    }
                    break;
                }
            } else {
                result = true;
            }
        }
        return result;
    }
}

