/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.sasheditor.internal;

import org.eclipse.papyrus.infra.core.sasheditor.internal.ComponentPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.EditorPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.PartVisitor;
import org.eclipse.papyrus.infra.core.sasheditor.internal.RootPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.SashPanelPart;
import org.eclipse.papyrus.infra.core.sasheditor.internal.TabFolderPart;

public class ShowPartStatusVisitor
extends PartVisitor {
    int level = 1;

    @Override
    public boolean accept(RootPart tile) {
        this.indent();
        tile.showStatus();
        ++this.level;
        super.accept(tile);
        --this.level;
        return true;
    }

    private void indent() {
        if (this.level < 1) {
            return;
        }
        int i = 0;
        while (i < this.level - 1) {
            System.out.print("|   ");
            ++i;
        }
        System.out.print("+ ");
    }

    @Override
    public boolean accept(SashPanelPart tile) {
        this.indent();
        tile.showStatus();
        ++this.level;
        super.accept(tile);
        --this.level;
        return true;
    }

    @Override
    public boolean accept(TabFolderPart tile) {
        this.indent();
        tile.showStatus();
        ++this.level;
        super.accept(tile);
        --this.level;
        return true;
    }

    @Override
    public boolean accept(EditorPart tile) {
        this.indent();
        tile.showStatus();
        ++this.level;
        super.accept(tile);
        --this.level;
        return true;
    }

    @Override
    public boolean accept(ComponentPart tile) {
        this.indent();
        tile.showStatus();
        ++this.level;
        super.accept(tile);
        --this.level;
        return true;
    }
}

