/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.databinding;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.widgets.databinding.StyledTextObservableValue;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.providers.UnchangedObject;
import org.eclipse.swt.custom.StyledText;

public class StyledTextReferenceDialogObservableValue
extends StyledTextObservableValue {
    private AbstractValueEditor referenceDialog;
    private ILabelProvider labelProvider;

    public StyledTextReferenceDialogObservableValue(AbstractValueEditor dialog, StyledText styledText, IObservableValue modelObservable, int eventType, ILabelProvider labelProvider) {
        super(styledText, modelObservable, eventType);
        this.referenceDialog = dialog;
        this.labelProvider = labelProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider != null ? labelProvider : new LabelProvider();
    }

    @Override
    protected void doSetValue(Object value) {
        if (this.modelProperty != null && this.modelProperty.hasDifferentValues()) {
            this.text.setText(UnchangedObject.instance.toString());
            this.currentValue = UnchangedObject.instance;
        } else if (value instanceof String) {
            this.text.setText((String)value);
            this.currentValue = value;
        } else {
            this.text.setText(this.labelProvider.getText(value));
            this.currentValue = value;
        }
        this.referenceDialog.update();
    }
}

