/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ui.IMemento;

class LocalMemento
implements InvocationHandler {
    private static final Class<?>[] INTERFACES = new Class[]{IMemento.class};
    private static final Map<Method, Method> delegates = LocalMemento.createDelegates();
    private final String type;
    private final String id;
    private final List<IMemento> children = new ArrayList<IMemento>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String textData;

    LocalMemento(String type, String id) {
        this.type = type;
        this.id = id;
    }

    static IMemento createMemento(String type, String id) {
        LocalMemento handler = new LocalMemento(type, id);
        return (IMemento)Proxy.newProxyInstance(LocalMemento.class.getClassLoader(), INTERFACES, (InvocationHandler)handler);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        Method implementation = delegates.get(method);
        if (implementation == null) {
            throw new UnsupportedOperationException("dynamic proxy handler does not understand " + method.getName());
        }
        result = implementation.invoke((Object)this, args);
        return result;
    }

    @API
    String getType() {
        return this.type;
    }

    @API
    String getID() {
        return this.id;
    }

    @API
    IMemento createChild(String type) {
        return this.createChild(type, null);
    }

    @API
    IMemento createChild(String type, String id) {
        IMemento result = LocalMemento.createMemento(type, id);
        this.children.add(result);
        return result;
    }

    @API
    IMemento getChild(String type) {
        IMemento result = null;
        for (IMemento next : this.children) {
            if (!type.equals(next.getType())) continue;
            result = next;
            break;
        }
        return result;
    }

    @API
    IMemento[] getChildren() {
        return this.children.toArray(new IMemento[this.children.size()]);
    }

    @API
    IMemento[] getChildren(String type) {
        ArrayList<IMemento> result = new ArrayList<IMemento>(this.children.size());
        for (IMemento next : this.children) {
            if (!type.equals(next.getType())) continue;
            result.add(next);
        }
        return result.toArray(new IMemento[result.size()]);
    }

    @API
    Float getFloat(String key) {
        return this.coerce(this.attributes.get(key), Float.class);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T coerce(Object value, Class<T> type) {
        Object result;
        if (value == null) {
            result = value;
            return type.cast(result);
        } else if (type.isInstance(value)) {
            result = value;
            return type.cast(result);
        } else if (Number.class.isAssignableFrom(type) && value instanceof Number) {
            Number number = (Number)value;
            if (type == Integer.class) {
                result = number.intValue();
                return type.cast(result);
            } else {
                if (type != Float.class) throw new IllegalArgumentException("unsupported numeric type: " + type.getSimpleName());
                result = Float.valueOf(number.floatValue());
            }
            return type.cast(result);
        } else if (Number.class.isAssignableFrom(type) && value instanceof String) {
            String string = (String)value;
            if (type == Integer.class) {
                result = Integer.valueOf(string);
                return type.cast(result);
            } else {
                if (type != Float.class) throw new IllegalArgumentException("unsupported numeric type: " + type.getSimpleName());
                result = Float.valueOf(string);
            }
            return type.cast(result);
        } else if (type == Boolean.class) {
            if (!(value instanceof String)) throw new IllegalArgumentException("unsupported boolean conversion from type: " + (value == null ? "null" : value.getClass().getSimpleName()));
            result = Boolean.valueOf((String)value);
            return type.cast(result);
        } else {
            if (type != String.class) throw new IllegalArgumentException("unsupported attribute type: " + type.getSimpleName());
            result = String.valueOf(value);
        }
        return type.cast(result);
    }

    @API
    Integer getInteger(String key) {
        return this.coerce(this.attributes.get(key), Integer.class);
    }

    @API
    String getString(String key) {
        return this.coerce(this.attributes.get(key), String.class);
    }

    @API
    Boolean getBoolean(String key) {
        return this.coerce(this.attributes.get(key), Boolean.class);
    }

    @API
    String getTextData() {
        return this.textData;
    }

    @API
    String[] getAttributeKeys() {
        return this.attributes.keySet().toArray(new String[this.attributes.size()]);
    }

    @API
    void putFloat(String key, float value) {
        this.attributes.put(key, Float.valueOf(value));
    }

    @API
    void putInteger(String key, int value) {
        this.attributes.put(key, value);
    }

    @API
    void putString(String key, String value) {
        this.attributes.put(key, value);
    }

    @API
    void putBoolean(String key, boolean value) {
        this.attributes.put(key, value);
    }

    @API
    void putTextData(String data) {
        this.textData = data;
    }

    private boolean isLocalMemento(IMemento memento) {
        return memento != null && Proxy.isProxyClass(memento.getClass()) && Proxy.getInvocationHandler(memento) instanceof LocalMemento;
    }

    @API
    void putMemento(IMemento memento) {
        if (!this.isLocalMemento(memento)) {
            throw new IllegalArgumentException("memento is not a local memento");
        }
        this.children.add(memento);
    }

    @API(owner=Object.class)
    public String toString() {
        StringBuilder result = new StringBuilder();
        this.append(result, 0);
        return result.toString();
    }

    private void append(StringBuilder buf, int depth) {
        int i = 0;
        while (i < depth) {
            buf.append("  ");
            ++i;
        }
        buf.append("LocalMemento(");
        buf.append(this.type);
        if (this.id != null) {
            buf.append('[').append(this.id).append(']');
        }
        buf.append(") ").append(this.attributes);
        buf.append('\n');
        int nextDepth = depth + 1;
        for (IMemento next : this.children) {
            ((LocalMemento)Proxy.getInvocationHandler(next)).append(buf, nextDepth);
        }
    }

    private static Map<Method, Method> createDelegates() {
        HashMap<Method, Method> result = new HashMap<Method, Method>();
        Method[] methodArray = LocalMemento.class.getDeclaredMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method implementation = methodArray[n2];
            if (implementation.isAnnotationPresent(API.class)) {
                try {
                    Method api = implementation.getAnnotation(API.class).owner().getMethod(implementation.getName(), implementation.getParameterTypes());
                    result.put(api, implementation);
                }
                catch (NoSuchMethodException e) {
                    throw new LinkageError("Incompatible IMemento API change: " + implementation.getName());
                }
            }
            ++n2;
        }
        return result;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface API {
        public Class<?> owner() default IMemento.class;
    }
}

