/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.architecture.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.PropertyDescriptor;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.papyrus.infra.gmfdiag.common.Activator;
import org.eclipse.papyrus.infra.ui.architecture.messages.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class CustomAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    public CustomAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
        return new CustomPropertySource(object, itemPropertySource);
    }

    public String selectTypeDialog(Control cellEditorWindow, EObject eObject, EStructuralFeature feature) {
        URI uri = eObject.eResource().getURI();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile file = workspace.getRoot().getFile((IPath)new Path(uri.toPlatformString(false)));
        IProject project = file.getProject();
        IJavaProject[] javaProject = new IJavaProject[]{JavaCore.create((IProject)project)};
        IJavaSearchScope searchScope = SearchEngine.createJavaSearchScope((IJavaElement[])javaProject);
        int scope = 2;
        String filter = (String)eObject.eGet(feature);
        if (filter == null || filter.length() == 0) {
            filter = "**";
        }
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)cellEditorWindow.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)searchScope, (int)scope, (boolean)false, (String)filter);
            dialog.setTitle(Messages.CustomAdapterFactoryContentProvider_0);
            if (dialog.open() == 0) {
                IType type = (IType)dialog.getResult()[0];
                return type.getFullyQualifiedName('$');
            }
        }
        catch (JavaModelException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    private class CustomPropertyDescriptor
    extends PropertyDescriptor {
        public CustomPropertyDescriptor(Object object, IItemPropertyDescriptor itemPropertyDescriptor) {
            super(object, itemPropertyDescriptor);
        }

        public CellEditor createPropertyEditor(Composite composite) {
            EClassifier etype;
            final EObject eObject = (EObject)this.object;
            final EStructuralFeature feature = (EStructuralFeature)this.itemPropertyDescriptor.getFeature((Object)eObject);
            if ((feature.getName().endsWith("Class") || feature.getName().endsWith("class")) && (etype = feature.getEType()) instanceof EDataType && etype.getName().equals("EString")) {
                DialogCellEditor cellEditor = new DialogCellEditor(composite){

                    protected Object openDialogBox(Control cellEditorWindow) {
                        return CustomAdapterFactoryContentProvider.this.selectTypeDialog(cellEditorWindow, eObject, feature);
                    }
                };
                return cellEditor;
            }
            return super.createPropertyEditor(composite);
        }
    }

    private class CustomPropertySource
    extends PropertySource {
        public CustomPropertySource(Object object, IItemPropertySource itemPropertySource) {
            super(object, itemPropertySource);
        }

        protected IPropertyDescriptor createPropertyDescriptor(IItemPropertyDescriptor itemPropertyDescriptor) {
            return new CustomPropertyDescriptor(this.object, itemPropertyDescriptor);
        }
    }
}

