/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.internationalization.utils;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.internationalization.InternationalizationEntry;
import org.eclipse.papyrus.infra.internationalization.InternationalizationPackage;
import org.eclipse.papyrus.infra.internationalization.common.editor.IInternationalizationEditor;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationModelResource;
import org.eclipse.papyrus.infra.internationalization.utils.QualifiedNameUtils;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;

public class EntryPartLabelSynchronizer {
    private InternationalizationEntry entry;
    private IInternationalizationEditor editorPart;
    private InternationalizationModelResource modelResource;
    private final Adapter labelListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (notification.getFeature() == InternationalizationPackage.eINSTANCE.getInternationalizationEntry_Value()) {
                EntryPartLabelSynchronizer.this.editorPart.modifyPartName(EntryPartLabelSynchronizer.this.getLabel(EntryPartLabelSynchronizer.this.entry.getKey()));
            }
        }
    };

    public EntryPartLabelSynchronizer(InternationalizationEntry entry, IInternationalizationEditor editorPart, InternationalizationModelResource modelResource) {
        this.editorPart = editorPart;
        this.modelResource = modelResource;
        this.setEntry(entry);
    }

    public void setEntry(InternationalizationEntry entry) {
        if (entry != null && entry.getKey() != null) {
            entry.eAdapters().remove((Object)this.labelListener);
            this.entry = entry;
            this.editorPart.modifyPartName(this.getLabel(entry.getKey()));
            entry.eAdapters().add((Object)this.labelListener);
        }
    }

    public void dispose() {
        this.editorPart = null;
        this.modelResource = null;
        if (this.entry != null) {
            this.entry.eAdapters().remove((Object)this.labelListener);
        }
    }

    protected String getLabel(Object object) {
        String value = "";
        if (object instanceof Table) {
            value = this.getTableLabel((Table)this.entry.getKey());
        } else if (object instanceof Diagram) {
            value = this.getDiagramLabel((Diagram)this.entry.getKey());
        }
        return value;
    }

    protected String getTableLabel(Table table) {
        String result = null;
        EObject tableOwner = table.getOwner();
        if (tableOwner == null) {
            tableOwner = table.getContext();
        }
        if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)tableOwner)) {
            result = this.modelResource.getValueForEntryKey(tableOwner.eResource().getURI(), (EObject)table);
        }
        return result != null ? result : table.getName();
    }

    protected String getDiagramLabel(Diagram diagram) {
        String result = null;
        if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)QualifiedNameUtils.getOwner(diagram))) {
            result = this.modelResource.getValueForEntryKey(diagram.eResource().getURI(), (EObject)diagram);
        }
        return result != null ? result : diagram.getName();
    }
}

