/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.concurrent.Executor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.core.resource.IModelSetSnippet;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.resource.ResourceAdapter;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.util.UIUtil;
import org.eclipse.papyrus.uml.decoratormodel.helper.DecoratorModelUtils;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.commands.LoadAvailableDecoratorModelsHandler;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.preferences.ProfileExternalizationUIPreferences;
import org.eclipse.papyrus.uml.profile.service.ReapplyProfilesService;
import org.eclipse.papyrus.uml.tools.model.UmlModel;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.UMLPackage;

public class AvailableDecoratorModelsSnippet
extends ResourceAdapter
implements IModelSetSnippet {
    private static final String EDITOR_SERVICE_ID = IMultiDiagramEditor.class.getName();
    private Executor profileRefreshExecutor;
    private ModelSet modelSet;

    public void start(ModelSet modelsManager) {
        this.modelSet = modelsManager;
        this.addAdapter((Notifier)modelsManager);
        this.profileRefreshExecutor = UIUtil.createAsyncOnceExecutor();
    }

    public void dispose(ModelSet modelsManager) {
        if (modelsManager == this.modelSet) {
            this.profileRefreshExecutor = null;
            this.removeAdapter((Notifier)modelsManager);
            this.modelSet = null;
        }
    }

    protected void handleResourceLoaded(Resource resource) {
        Package package_ = (Package)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
        if (package_ != null) {
            Resource root;
            if (this.isPromptEnabled() && (root = EcoreUtil.getRootContainer((EObject)package_).eResource()) != null && this.modelSet.getURIWithoutExtension().equals(root.getURI().trimFileExtension())) {
                Futures.addCallback((ListenableFuture)DecoratorModelUtils.hasUnloadedDecoratorModelsAsync((Package)package_, (boolean)false), this.promptToLoadDecoratorModels(package_), (Executor)Activator.getDefault().getExecutorService());
            }
            if (DecoratorModelUtils.isDecoratorModel((Resource)resource) && this.profileRefreshExecutor != null) {
                Package rootPackage;
                UmlModel uml = (UmlModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                Package package_2 = rootPackage = uml == null ? null : (Package)EcoreUtil.getObjectByType((Collection)uml.getResource().getContents(), (EClassifier)UMLPackage.Literals.PACKAGE);
                if (rootPackage != null) {
                    this.profileRefreshExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (AvailableDecoratorModelsSnippet.this.modelSet != null) {
                                AvailableDecoratorModelsSnippet.this.refreshProfiles(rootPackage);
                            }
                        }
                    });
                }
            }
        }
    }

    boolean isPromptEnabled() {
        boolean result = false;
        if (ProfileExternalizationUIPreferences.getAutoPromptToLoadProfileApplications()) {
            try {
                ServicesRegistry services = ServiceUtilsForResourceSet.getInstance().getServiceRegistry((ResourceSet)this.modelSet);
                boolean bl = result = services != null && services.isStarted((Object)EDITOR_SERVICE_ID);
                if (result) {
                    UmlModel uml = (UmlModel)this.modelSet.getModel("org.eclipse.papyrus.infra.core.resource.uml.UmlModel");
                    Resource mainResource = uml == null ? null : uml.getResource();
                    result = mainResource == null || !DecoratorModelUtils.isDecoratorModel((Resource)mainResource);
                }
            }
            catch (ServiceException serviceException) {
                // empty catch block
            }
        }
        return result;
    }

    static boolean isLoadedAndAttached(EObject object) {
        return !object.eIsProxy() && object.eResource() != null;
    }

    private FutureCallback<Boolean> promptToLoadDecoratorModels(final Package package_) {
        return new FutureCallback<Boolean>(){

            public void onSuccess(Boolean result) {
                IWorkbenchWindow window;
                if (result.booleanValue() && AvailableDecoratorModelsSnippet.isLoadedAndAttached((EObject)package_) && (window = Activator.getActiveWorkbenchWindow()) != null) {
                    LoadAvailableDecoratorModelsHandler.promptToLoadAvailableProfileApplications(window.getShell(), package_, true);
                }
            }

            public void onFailure(Throwable t) {
            }
        };
    }

    protected void refreshProfiles(Package rootPackage) {
        ReapplyProfilesService reapplyProfiles;
        try {
            reapplyProfiles = (ReapplyProfilesService)ServiceUtilsForEObject.getInstance().getService(ReapplyProfilesService.class, (Object)rootPackage);
        }
        catch (ServiceException ex) {
            return;
        }
        reapplyProfiles.checkProfiles();
    }
}

