/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.command.LayerCommandUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class RowReorderStartCommand
implements ILayerCommand {
    private RowPositionCoordinate fromRowPositionCoordinate;

    public RowReorderStartCommand(ILayer layer, int fromRowPosition) {
        this.fromRowPositionCoordinate = new RowPositionCoordinate(layer, fromRowPosition);
    }

    protected RowReorderStartCommand(RowReorderStartCommand command) {
        this.fromRowPositionCoordinate = command.fromRowPositionCoordinate;
    }

    public int getFromRowPosition() {
        return this.fromRowPositionCoordinate.getRowPosition();
    }

    @Override
    public boolean convertToTargetLayer(ILayer targetLayer) {
        RowPositionCoordinate targetFromRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(this.fromRowPositionCoordinate, targetLayer);
        if (targetFromRowPositionCoordinate != null) {
            this.fromRowPositionCoordinate = targetFromRowPositionCoordinate;
            return true;
        }
        return false;
    }

    @Override
    public RowReorderStartCommand cloneCommand() {
        return new RowReorderStartCommand(this);
    }
}

