/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.util.wizard;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.CustomPackage;
import org.eclipse.papyrus.emf.facet.custom.metamodel.v0_2_0.custom.Customization;
import org.eclipse.papyrus.emf.facet.custom.sdk.core.ICustomizationActions;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.Activator;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.Messages;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.util.wizard.page.CreateCustomizationWizardPage;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.util.wizard.page.CustomPropertyWizardPage;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.wizard.page.ICreateCustomizationWizardPage;
import org.eclipse.papyrus.emf.facet.custom.sdk.ui.internal.wizard.page.ICustomizationPropertyWizardPage;
import org.eclipse.papyrus.emf.facet.util.core.Logger;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class CreateCustimizationWizardImpl
extends Wizard
implements INewWizard {
    private WizardDialog dialog;
    private IStructuredSelection selection;
    private IWorkbench workbench;
    private final ICreateCustomizationWizardPage customWizardPage;
    private final ICustomizationPropertyWizardPage propertyWP;
    private boolean openCustom = true;

    public CreateCustimizationWizardImpl() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection());
    }

    public CreateCustimizationWizardImpl(ISelection selection, boolean openCustom) {
        this(selection);
        this.openCustom = openCustom;
    }

    public CreateCustimizationWizardImpl(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)selection;
        }
        this.setWindowTitle(Messages.Create_Customization_Model);
        this.customWizardPage = new CreateCustomizationWizardPage("Whatever", this.selection);
        this.propertyWP = new CustomPropertyWizardPage("Whatever");
    }

    public void addPages() {
        this.addPage(this.customWizardPage);
        this.addPage(this.propertyWP);
    }

    public int open() {
        this.dialog = new WizardDialog(Display.getDefault().getShells()[0], (IWizard)this);
        int result = 1;
        if (this.dialog != null) {
            result = this.dialog.open();
        }
        return result;
    }

    public boolean performFinish() {
        return this.finish();
    }

    protected IWorkbenchWindow selectWorkbenchWindow() {
        if (this.workbench == null) {
            this.workbench = PlatformUI.getWorkbench();
        }
        IWorkbenchWindow workbenchWindow = this.workbench.getActiveWorkbenchWindow();
        return workbenchWindow;
    }

    protected WorkspaceModifyOperation createOperation(final IFile modelFile) {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        Customization customization = CreateCustimizationWizardImpl.this.createInitialCustomization();
                        ICustomizationActions.INSTANCE.saveCustomization(customization, modelFile);
                    }
                    catch (Exception exception) {
                        Logger.logError((Throwable)exception, (Plugin)Activator.getDefault());
                        progressMonitor.done();
                    }
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        return operation;
    }

    protected void openNewFile(IFile modelFile, IWorkbenchWindow workbenchWindow, IWorkbenchPage page) {
        try {
            String fileName = modelFile.getName();
            IEditorRegistry editorRegistry = this.workbench.getEditorRegistry();
            IEditorDescriptor defaultEditor = editorRegistry.getDefaultEditor(fileName);
            String editorId = defaultEditor.getId();
            FileEditorInput editorInput = new FileEditorInput(modelFile);
            page.openEditor((IEditorInput)editorInput, editorId);
        }
        catch (PartInitException exception) {
            MessageDialog.openError((Shell)workbenchWindow.getShell(), (String)"Open Editor", (String)exception.getMessage());
        }
    }

    protected IWorkbenchPage selectNewFile(IFile modelFile, IWorkbenchWindow workbenchWindow) {
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            StructuredSelection targetSelection = new StructuredSelection((Object)modelFile);
            this.getShell().getDisplay().asyncExec(new Runnable((ISelection)targetSelection){
                private final /* synthetic */ ISelection val$targetSelection;
                {
                    this.val$targetSelection = iSelection;
                }

                @Override
                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(this.val$targetSelection);
                }
            });
        }
        return page;
    }

    public boolean canFinish() {
        return this.propertyWP.isPageComplete();
    }

    public void init(IWorkbench newWorkbench, IStructuredSelection newSelection) {
        this.workbench = newWorkbench;
        this.selection = newSelection;
    }

    protected Customization createInitialCustomization() {
        Customization customization = CustomPackage.eINSTANCE.getCustomFactory().createCustomization();
        String projectName = CreateCustimizationWizardImpl.getProjectName();
        String modelCustomName = this.getModelFile().getName().replaceAll(".custom", "");
        customization.setName(String.valueOf(projectName) + "." + modelCustomName);
        customization.setNsURI(this.propertyWP.getNsUri());
        customization.setNsPrefix(this.propertyWP.getPrefix());
        return customization;
    }

    private static String getProjectName() {
        String activeProjectName = null;
        IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        if (editorPart != null) {
            FileEditorInput input = (FileEditorInput)editorPart.getEditorInput();
            IFile file = input.getFile();
            IProject activeProject = file.getProject();
            activeProjectName = activeProject.getName();
        }
        return activeProjectName;
    }

    public IFile getModelFile() {
        return this.customWizardPage.getModelFile();
    }

    public IWizardPage next() {
        IWizardPage nextPage = this.getNextPage(this.getCurrentPage());
        this.dialog.showPage(nextPage);
        return nextPage;
    }

    public IWizardPage previous() {
        IWizardPage previousPage = this.getPreviousPage(this.getCurrentPage());
        this.dialog.showPage(previousPage);
        return previousPage;
    }

    public boolean finish() {
        boolean result = false;
        if (this.canFinish()) {
            try {
                IFile modelFile = this.getModelFile();
                WorkspaceModifyOperation operation = this.createOperation(modelFile);
                this.getContainer().run(false, false, (IRunnableWithProgress)operation);
                if (this.openCustom) {
                    IWorkbenchWindow workbenchWindow = this.selectWorkbenchWindow();
                    IWorkbenchPage page = this.selectNewFile(modelFile, workbenchWindow);
                    this.openNewFile(modelFile, workbenchWindow, page);
                }
                result = true;
            }
            catch (Exception exception) {
                Logger.logError((Throwable)exception, (Plugin)Activator.getDefault());
            }
        }
        return result;
    }

    public WizardDialog getDialog() {
        return this.dialog;
    }

    public IWizardPage getCurrentPage() {
        return this.getContainer().getCurrentPage();
    }
}

