/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.architecture.listeners;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.papyrus.infra.architecture.Activator;
import org.eclipse.papyrus.infra.architecture.listeners.IArchitectureDescriptionListener;

public class ArchitectureDescriptionNotifier {
    private static final String EXTENSION_POINT_ID = "org.eclipse.papyrus.infra.architecture.listeners";
    private static final String LISTENER_CLASS = "class";
    private static ArchitectureDescriptionNotifier notifier;
    private static Collection<IArchitectureDescriptionListener> listeners;

    public static synchronized ArchitectureDescriptionNotifier getInstance() {
        if (notifier == null) {
            notifier = new ArchitectureDescriptionNotifier();
            listeners = new ArrayList<IArchitectureDescriptionListener>();
            notifier.init();
        }
        return notifier;
    }

    public void fireArchitectureContextChanged(Notification notification) {
        for (IArchitectureDescriptionListener listener : listeners) {
            listener.architectureContextChanged(notification);
        }
    }

    public void fireArchitectureViewpointsChanged(Notification notification) {
        for (IArchitectureDescriptionListener listener : listeners) {
            listener.architectureViewpointsChanged(notification);
        }
    }

    private void init() {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            try {
                Object listenerClass = configurationElement.createExecutableExtension(LISTENER_CLASS);
                if (listenerClass instanceof IArchitectureDescriptionListener) {
                    listeners.add((IArchitectureDescriptionListener)listenerClass);
                }
            }
            catch (CoreException e) {
                Activator.log.error((Throwable)e);
            }
            ++n2;
        }
    }
}

