/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.validation.internal.actions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.services.markerlistener.IPapyrusMarker;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class AbstractMarkerAction
extends BaseSelectionListenerAction {
    private IWorkbenchSite site;
    private Collection<IPapyrusMarker> markers;

    public AbstractMarkerAction(IWorkbenchSite site, String label) {
        super(label);
        this.site = site;
        this.setEnabled(false);
    }

    protected IWorkbenchSite getSite() {
        return this.site;
    }

    protected IPapyrusMarker getMarker() {
        return (IPapyrusMarker)Iterables.getFirst(this.markers, null);
    }

    protected Collection<IPapyrusMarker> getMarkers() {
        return this.markers;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Collection<Object> collection = this.markers = selection.isEmpty() ? Collections.emptyList() : Lists.newArrayList((Iterable)Iterables.filter((Iterable)selection.toList(), IPapyrusMarker.class));
        return !this.markers.isEmpty() && super.updateSelection(selection);
    }
}

