/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.modelexplorer.internal.handlers;

import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.papyrus.infra.emf.gmf.command.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.utils.utils.LabelInternationalizationUtils;
import org.eclipse.papyrus.infra.textedit.modelexplorer.internal.commands.RenameTextDocumentLabelCommand;
import org.eclipse.papyrus.infra.textedit.modelexplorer.internal.handlers.AbstractTextDocumentCommandHandler;
import org.eclipse.papyrus.infra.textedit.modelexplorer.internal.messages.Messages;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocumentPackage;
import org.eclipse.papyrus.views.modelexplorer.commands.RenameElementCommand;
import org.eclipse.papyrus.views.modelexplorer.util.ModelExplorerEditionUtil;

public class RenameTextDocumentHandler
extends AbstractTextDocumentCommandHandler {
    protected Command getCommand(IEvaluationContext context) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain(context);
        List<TextDocument> documents = this.getSelectedTextDocument();
        if (editingDomain != null && documents.size() == 1) {
            TextDocument document = documents.get(0);
            String documentLabel = LabelInternationalizationUtils.getLabelWithoutSubstract((EObject)document, (boolean)true);
            if (documentLabel != null && LabelInternationalizationPreferencesUtils.getInternationalizationPreference((EObject)document)) {
                RenameTextDocumentLabelCommand cmd = new RenameTextDocumentLabelCommand(editingDomain, "ChangeTextDocumentLabelCommand", (EObject)document, documentLabel, Messages.RenameTextDocumentHandler_ChangeTextDocumentLabel);
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            String currentName = document.getName();
            if (currentName != null) {
                EAttribute nameFeature = TextDocumentPackage.eINSTANCE.getTextDocument_Name();
                return new RenameElementCommand(editingDomain, "RenameTextDocumentCommand", (EObject)document, currentName, (EStructuralFeature)nameFeature, Messages.RenameTextDocumentHandler_RenameAnExistingDocument, Messages.RenameTextDocumentHandler_newName);
            }
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected boolean computeEnabled(IEvaluationContext context) {
        boolean computeEnabled = super.computeEnabled(context);
        if (computeEnabled) {
            List selectedElements = this.getSelectedElements();
            EObject selection = (EObject)selectedElements.get(0);
            computeEnabled = !EMFHelper.isReadOnly((EObject)selection);
        }
        return computeEnabled;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        EObject selectedDocument = this.getSelectedElement();
        if (ModelExplorerEditionUtil.isHandledByDirectEditor((EObject)selectedDocument)) {
            ModelExplorerEditionUtil.editElement((EObject)selectedDocument);
        } else {
            super.execute(event);
        }
        return null;
    }
}

