/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.ui;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.infra.services.labelprovider.service.LabelProviderService;
import org.eclipse.papyrus.uml.extensionpoints.profile.IRegisteredProfile;
import org.eclipse.papyrus.uml.modelrepair.ui.BrowseProfilesBlock;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BrowseProfilesDialog
extends TrayDialog {
    private final EPackage schema;
    private final LabelProviderService labelProviderService;
    private Text profileText;
    private URI selectedProfileURI;

    public BrowseProfilesDialog(Shell shell, EPackage schema, LabelProviderService labelProviderService) {
        this((IShellProvider)new SameShellProvider((Control)shell), schema, labelProviderService);
    }

    public BrowseProfilesDialog(IShellProvider parentShell, EPackage schema, LabelProviderService labelProviderService) {
        super(parentShell);
        this.schema = schema;
        this.labelProviderService = labelProviderService;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Apply Profile");
        newShell.setMinimumSize(300, 150);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        Composite main = new Composite(contents, 0);
        main.setLayout((Layout)new GridLayout(2, false));
        main.setLayoutData((Object)new GridData(4, 4, true, true));
        Label messageLabel = new Label(main, 64);
        messageLabel.setText(NLS.bind((String)"Select a registered or a workspace profile to apply for recovery of unrecognized stereotypes from \"{0}\".", (Object)this.labelProviderService.getLabelProvider().getText((Object)this.schema)));
        GridData span2 = new GridData(4, 1, true, false);
        span2.horizontalSpan = 2;
        messageLabel.setLayoutData((Object)span2);
        EventBus bus = new EventBus("profileSelection");
        BrowseProfilesBlock block = new BrowseProfilesBlock(bus, this.labelProviderService);
        block.createControl(main, 1).setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        Label profileLabel = new Label(main, 0);
        profileLabel.setText("Profile:");
        this.profileText = new Text(main, 2056);
        this.profileText.setLayoutData((Object)new GridData(4, 1, true, false));
        bus.register(new Object(){

            @Subscribe
            public void workspaceProfileSelected(IFile file) {
                IPath filePath = file.getFullPath();
                BrowseProfilesDialog.this.setSelectedProfileURI(URI.createPlatformResourceURI((String)filePath.toPortableString(), (boolean)true));
                BrowseProfilesDialog.this.updateProfile();
            }

            @Subscribe
            public void registeredProfileSelected(IRegisteredProfile profile) {
                BrowseProfilesDialog.this.setSelectedProfileURI(profile.getUri());
            }
        });
        return contents;
    }

    protected Control createContents(Composite parent) {
        this.setHelpAvailable(false);
        Control result = super.createContents(parent);
        this.updateProfile();
        return result;
    }

    public void setSelectedProfileURI(URI selectedProfileURI) {
        this.selectedProfileURI = selectedProfileURI;
        this.updateProfile();
    }

    public URI getSelectedProfileURI() {
        return this.selectedProfileURI;
    }

    protected void cancelPressed() {
        this.selectedProfileURI = null;
        super.cancelPressed();
    }

    protected void updateProfile() {
        if (this.profileText != null && !this.profileText.isDisposed()) {
            if (this.selectedProfileURI == null) {
                this.profileText.setText("");
            } else {
                this.profileText.setText(this.selectedProfileURI.toString());
            }
            this.getButton(0).setEnabled(this.selectedProfileURI != null);
        }
    }
}

