/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.properties.modelelement;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.papyrus.infra.gmfdiag.common.decoration.ConnectionDecorationRegistry;
import org.eclipse.papyrus.infra.gmfdiag.common.editpart.ConnectionEditPart;
import org.eclipse.papyrus.infra.gmfdiag.common.types.NotationTypesMap;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.LineStyleEnum;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PortPositionEnum;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.PositionEnum;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.ConnectionDecorationStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.CustomChildFloatingLabelBooleanStyleObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.CustomIntStyleCompartmentObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.databinding.CustomStringStyleCompartmentObservableValue;
import org.eclipse.papyrus.infra.gmfdiag.properties.modelelement.CustomStyleModelElement;
import org.eclipse.papyrus.infra.properties.contexts.DataContextElement;
import org.eclipse.papyrus.infra.properties.contexts.Property;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.StaticContentProvider;

public class AdvanceStyleModelElement
extends CustomStyleModelElement {
    View view;

    public AdvanceStyleModelElement(View source, DataContextElement context) {
        this(source, null, context);
    }

    public AdvanceStyleModelElement(View source, EditingDomain domain, DataContextElement element) {
        super(source, domain, element);
        this.view = source;
    }

    @Override
    public IObservable doGetObservable(String propertyPath) {
        Object observable = null;
        Property property = this.findProperty(propertyPath);
        if (property != null) {
            observable = propertyPath.equals("linePosition") || propertyPath.equals("lineLengthRatio") ? new CustomStringStyleCompartmentObservableValue(this.view, this.domain, propertyPath) : (propertyPath.equals("lineLength") ? new CustomIntStyleCompartmentObservableValue(this.view, this.domain, propertyPath) : (propertyPath.equals("visible") && !"FloatingLabel".equals(NotationTypesMap.instance.getHumanReadableType((View)this.source)) ? new CustomChildFloatingLabelBooleanStyleObservableValue(this.view, this.domain, propertyPath) : (propertyPath.equals("targetDecoration") || propertyPath.equals("sourceDecoration") ? new ConnectionDecorationStyleObservableValue(this.view, this.domain, propertyPath) : super.doGetObservable(propertyPath))));
        }
        return observable;
    }

    @Override
    public IStaticContentProvider getContentProvider(String propertyPath) {
        StaticContentProvider contentProvider = null;
        if (propertyPath.equals("textAlignment") || propertyPath.equals("linePosition")) {
            Object[] textAlignments = new String[]{PositionEnum.LEFT.toString(), PositionEnum.CENTER.toString(), PositionEnum.RIGHT.toString()};
            contentProvider = new StaticContentProvider(textAlignments);
        } else if (propertyPath.equals("borderStyle")) {
            Object[] borderStyles = new String[]{LineStyleEnum.DASH.toString(), LineStyleEnum.DASH_DOT.toString(), LineStyleEnum.DASH_DOT_DOT.toString(), LineStyleEnum.DOT.toString(), LineStyleEnum.SOLID.toString(), LineStyleEnum.CUSTOM.toString()};
            contentProvider = new StaticContentProvider(borderStyles);
        } else if (propertyPath.equals("position")) {
            Object[] positions = new String[]{PositionEnum.EAST.toString(), PositionEnum.WEST.toString(), PositionEnum.NORTH.toString(), PositionEnum.SOUTH.toString(), PositionEnum.AUTO.toString()};
            contentProvider = new StaticContentProvider(positions);
        } else if (propertyPath.equals("portPosition")) {
            Object[] portPositions = new String[]{PortPositionEnum.INSIDE.toString(), PortPositionEnum.ONLINE.toString(), PortPositionEnum.OUTSIDE.toString()};
            contentProvider = new StaticContentProvider(portPositions);
        } else if (propertyPath.equals("targetDecoration") || propertyPath.equals("sourceDecoration")) {
            Map availableDecoration = ConnectionDecorationRegistry.getInstance().getAvailableDecoration();
            ArrayList decorations = new ArrayList(availableDecoration.keySet());
            decorations.addAll(Arrays.asList(ConnectionEditPart.DECORATION_VALUES));
            contentProvider = new StaticContentProvider(decorations.toArray());
        }
        return contentProvider != null ? contentProvider : super.getContentProvider(propertyPath);
    }

    @Override
    public ILabelProvider getLabelProvider(String propertyPath) {
        Object labelProvider = null;
        if (propertyPath.equals("targetDecoration") || propertyPath.equals("sourceDecoration")) {
            Map availableDecoration = ConnectionDecorationRegistry.getInstance().getAvailableDecoration();
            ArrayList decorations = new ArrayList(availableDecoration.keySet());
            decorations.addAll(Arrays.asList(ConnectionEditPart.DECORATION_VALUES));
            labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof String) {
                        String label = ConnectionDecorationRegistry.getInstance().getLabel((String)element);
                        return label != null ? label : (String)element;
                    }
                    return null;
                }
            };
        } else {
            labelProvider = super.getLabelProvider(propertyPath);
        }
        return labelProvider;
    }
}

