/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.textedit.properties.internal.papyrus;

import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.papyrus.infra.properties.ui.modelelement.EMFModelElement;
import org.eclipse.papyrus.infra.textedit.textdocument.TextDocument;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.swt.graphics.Image;

public class TextDocumentModelElement
extends EMFModelElement {
    private static final String KIND_ID_PROPERTY = "kindId";
    private static final String CUSTOM_KIND_ID_PROPERTY = "customKindId";

    public TextDocumentModelElement(TextDocument source, EditingDomain domain) {
        super((EObject)source, domain);
    }

    public TextDocument getSource() {
        return (TextDocument)super.getSource();
    }

    public TextDocumentModelElement(EObject source) {
        super(source);
    }

    protected IObservable doGetObservable(String propertyPath) {
        if (CUSTOM_KIND_ID_PROPERTY.equals(propertyPath)) {
            return super.doGetObservable(KIND_ID_PROPERTY);
        }
        return super.doGetObservable(propertyPath);
    }

    public ILabelProvider getLabelProvider(String propertyPath) {
        if (CUSTOM_KIND_ID_PROPERTY.equals(propertyPath)) {
            return new TextDocumentKindIdLabelProvider(this.getSource());
        }
        return super.getLabelProvider(propertyPath);
    }

    private class TextDocumentKindIdLabelProvider
    implements ILabelProvider {
        private TextDocument txtDocument;

        public TextDocumentKindIdLabelProvider(TextDocument txtDocument) {
            this.txtDocument = txtDocument;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
            this.txtDocument = null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            PolicyChecker checker = PolicyChecker.getFor((EObject)this.txtDocument);
            ViewPrototype prototype = ViewPrototype.get((EObject)this.txtDocument);
            if (!ViewPrototype.UNAVAILABLE_VIEW.equals(prototype) && !checker.isInViewpoint(prototype.getRepresentationKind())) {
                return prototype.getGrayedIconURI() == null || prototype.getGrayedIconURI().isEmpty() ? ViewPrototype.UNAVAILABLE_VIEW.getIcon() : prototype.getGrayedIcon();
            }
            return prototype.getIcon();
        }

        public String getText(Object element) {
            ViewPrototype prototype = ViewPrototype.get((EObject)this.txtDocument);
            if (prototype != null) {
                return prototype.getQualifiedName();
            }
            return "";
        }
    }
}

