/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.commands;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.NotificationBuilder;

public class RunNotificationCommand
extends AbstractTransactionalCommand {
    private NotificationBuilder notification;
    private static List<INotification> notifs = Lists.newArrayList();

    public RunNotificationCommand(TransactionalEditingDomain domain, String label, List affectedFiles, NotificationBuilder notification) {
        super(domain, label, affectedFiles);
        this.notification = notification;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.clearOldNotif();
        this.addNotif(this.notification.run());
        return CommandResult.newOKCommandResult();
    }

    private synchronized void addNotif(INotification notif) {
        notifs.add(notif);
    }

    private synchronized void clearOldNotif() {
        for (INotification notif : notifs) {
            notif.delete();
        }
        notifs.clear();
    }
}

