/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.dnd.commands;

import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.activity.dnd.commands.CreateTAndUpdateCommand;
import org.eclipse.papyrus.uml.diagram.activity.edit.dialogs.CreateLinkEndDateDialog;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.swt.widgets.Display;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.CreateLinkAction;
import org.eclipse.uml2.uml.DestroyLinkAction;
import org.eclipse.uml2.uml.LinkAction;
import org.eclipse.uml2.uml.LinkEndData;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.ReadLinkAction;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateLinkActionAndUpdateCommand<T extends EObject, E extends EObject, S extends EObject>
extends CreateTAndUpdateCommand<T, E, S> {
    public CreateLinkActionAndUpdateCommand(EditPart targetEditPart, Class<T> typeParameterClass, E targetElementDiagram, S sourceElement, boolean headless, IHintedType typeToCreate, Point location, String dropEditPartVisualID) {
        super(targetEditPart, typeParameterClass, targetElementDiagram, sourceElement, headless, typeToCreate, null, location, dropEditPartVisualID);
    }

    @Override
    protected void updateNewlyCreatedEObjectWithEObjectDragged(T elementToSet, S value) throws ExecutionException {
        if (!(value instanceof Association)) {
            return;
        }
        LinkAction linkAction = (LinkAction)elementToSet;
        List<Property> selectedProperties = null;
        CreateLinkEndDateDialog dialog = new CreateLinkEndDateDialog(Display.getDefault().getActiveShell(), (Association)value);
        if (dialog.open() == 0) {
            selectedProperties = dialog.getSelectedProperties();
        }
        EObject newCreatedElement = null;
        if (selectedProperties != null) {
            for (Property property : selectedProperties) {
                newCreatedElement = this.createElement((EObject)linkAction, (IElementType)this.getTypeToCreate(elementToSet));
                if (!(newCreatedElement instanceof LinkEndData)) {
                    return;
                }
                LinkEndData linkEndData = (LinkEndData)newCreatedElement;
                this.setElementFeature((EObject)linkEndData, (EStructuralFeature)UMLPackage.eINSTANCE.getLinkEndData_End(), property);
            }
        }
    }

    private IHintedType getTypeToCreate(T elementToSet) {
        if (elementToSet instanceof CreateLinkAction) {
            return UMLElementTypes.LINK_END_CREATION_DATA;
        }
        if (elementToSet instanceof DestroyLinkAction) {
            return UMLElementTypes.LINK_END_DESTRUCTION_DATA;
        }
        if (elementToSet instanceof ReadLinkAction) {
            return UMLElementTypes.LINK_END_DATA;
        }
        return UMLElementTypes.LINK_END_DATA;
    }

    private EObject createElement(EObject owner, IElementType type) throws ExecutionException {
        CommandResult commandResult;
        TransactionalEditingDomain domain = (TransactionalEditingDomain)EMFHelper.resolveEditingDomain((Object)this.targetEditPart);
        CreateElementRequest createElementRequest = new CreateElementRequest(domain, owner, type);
        CreateElementCommand creationElementCommand = new CreateElementCommand(createElementRequest);
        if (creationElementCommand.canExecute()) {
            creationElementCommand.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        if ((commandResult = creationElementCommand.getCommandResult()) != null && !commandResult.getStatus().isOK()) {
            return null;
        }
        return commandResult.getReturnValue() instanceof EObject ? (EObject)commandResult.getReturnValue() : null;
    }
}

