/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.emf.facet.doc.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javadoc;
import org.apache.tools.ant.types.FileSet;

public class GenerateApiJavadocTask
extends Javadoc {
    private String sourceTreePath = null;
    private Pattern pattern = Pattern.compile(".*");

    public void setSourceTreePath(String path) {
        this.sourceTreePath = path;
    }

    public void setPattern(String pattern) {
        this.pattern = Pattern.compile(pattern);
    }

    public void execute() throws BuildException {
        if (this.sourceTreePath == null) {
            throw new BuildException("sourceTreePath must be set");
        }
        this.getProject().log("sourceTreePath = " + this.sourceTreePath, 4);
        ArrayList<File> apiPackages = new ArrayList<File>();
        File root = new File(this.sourceTreePath);
        if (!root.isAbsolute()) {
            root = new File(this.getProject().getBaseDir(), this.sourceTreePath);
        }
        if (!root.exists()) {
            throw new BuildException("root path doesn't exist: " + root.getPath());
        }
        try {
            String[] stringArray = root.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                File manifestFile;
                File file;
                String childPath = stringArray[n2];
                boolean matches = this.pattern.matcher(childPath).matches();
                if (matches) {
                    this.getProject().log("pattern matches: " + childPath, 4);
                } else {
                    this.getProject().log("pattern rejects: " + childPath, 4);
                }
                if (matches && (file = new File(root, childPath)).isDirectory() && (manifestFile = new File(file, "META-INF/MANIFEST.MF")).exists()) {
                    FileInputStream fileInputStream = new FileInputStream(manifestFile);
                    Manifest manifest = new Manifest(fileInputStream);
                    Attributes mainAttributes = manifest.getMainAttributes();
                    for (Map.Entry<Object, Object> entry : mainAttributes.entrySet()) {
                        String[] packageEntries;
                        String name = entry.getKey().toString();
                        if (!"Export-Package".equals(name)) continue;
                        String value = (String)entry.getValue();
                        String[] stringArray2 = packageEntries = value.split(",");
                        int n3 = packageEntries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File packageDir;
                            String packageEntry = stringArray2[n4];
                            String[] parts = packageEntry.split(";");
                            String packageName = parts[0];
                            boolean internal = false;
                            int i = 1;
                            while (i < parts.length) {
                                if (parts[i].contains("x-internal") || parts[i].contains("x-friends")) {
                                    internal = true;
                                }
                                ++i;
                            }
                            if (!internal && (packageDir = new File(file.getPath(), "src/" + packageName.replace('.', '/'))).exists()) {
                                apiPackages.add(packageDir);
                            }
                            ++n4;
                        }
                    }
                    fileInputStream.close();
                }
                ++n2;
            }
        }
        catch (Exception e) {
            throw new BuildException("Error reading manifests", (Throwable)e);
        }
        for (File apiPackage : apiPackages) {
            String[] children = apiPackage.list();
            boolean packageImpl = false;
            boolean factoryImpl = false;
            String[] stringArray = children;
            int n = children.length;
            int n5 = 0;
            while (n5 < n) {
                String child = stringArray[n5];
                if (child.endsWith("PackageImpl.java")) {
                    packageImpl = true;
                }
                if (child.endsWith("FactoryImpl.java")) {
                    factoryImpl = true;
                }
                ++n5;
            }
            if (packageImpl && factoryImpl) {
                this.getProject().log("excluding metamodel implementation package: " + apiPackage.getPath(), 2);
                continue;
            }
            if (apiPackage.exists()) {
                System.out.println(apiPackage);
                FileSet fileSet = new FileSet();
                fileSet.setProject(this.getProject());
                fileSet.setDir(apiPackage);
                fileSet.setIncludes("*.java");
                System.out.println(fileSet);
                this.addFileset(fileSet);
                continue;
            }
            this.getProject().log("package doesn't exist: " + apiPackage, 0);
        }
        super.execute();
    }
}

