/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.editors;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.viewers.typed.ViewerProperties;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.providers.AbstractStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.providers.EncapsulatedContentProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class BooleanCombo
extends AbstractValueEditor {
    private ComboViewer viewer;

    public BooleanCombo(Composite parent) {
        this(parent, 0, null);
    }

    public BooleanCombo(Composite parent, int style, String label) {
        super(parent, style, label);
        CCombo combo = factory.createCCombo((Composite)this, style | 0x800);
        combo.setBackground(new Color((Device)combo.getDisplay(), 255, 255, 255));
        combo.setLayoutData((Object)this.getDefaultLayoutData());
        combo.setEditable(false);
        this.viewer = this.createComboViewer(combo);
        this.viewer.setContentProvider((IContentProvider)new EncapsulatedContentProvider(new AbstractStaticContentProvider(){

            @Override
            public Object[] getElements() {
                return new Boolean[]{Boolean.TRUE, Boolean.FALSE};
            }
        }));
        this.viewer.setInput((Object)"");
        this.setWidgetObservable((IObservableValue)ViewerProperties.singleSelection().observe((Viewer)this.viewer));
        this.setCommitOnFocusLost((Control)combo);
    }

    protected ComboViewer createComboViewer(CCombo combo) {
        return new ComboViewer(combo);
    }

    public BooleanCombo(Composite parent, int style) {
        this(parent, style, null);
    }

    public BooleanCombo(Composite parent, String label) {
        this(parent, 0, label);
    }

    @Override
    public Object getValue() {
        return ((StructuredSelection)this.viewer.getSelection()).getFirstElement();
    }

    @Override
    public Object getEditableType() {
        return Boolean.class;
    }

    @Override
    public void setReadOnly(boolean readOnly) {
        this.viewer.getCCombo().setEnabled(!readOnly);
    }

    @Override
    public boolean isReadOnly() {
        return !this.viewer.getCCombo().isEnabled();
    }

    public void setToolTipText(String text) {
        this.viewer.getCCombo().setToolTipText(text);
        super.setLabelToolTipText(text);
    }
}

