/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.nattable;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;

public class ServiceConfigAttributes {
    private static Map<Class<?>, ConfigAttribute<?>> configAttributes = new HashMap();

    private ServiceConfigAttributes() {
    }

    public static <T> ConfigAttribute<T> get(Class<T> serviceType) {
        return configAttributes.computeIfAbsent(serviceType, key -> new ConfigAttribute());
    }

    public static Configurator with(IConfigRegistry registry, Function<? super Class<?>, ?> serviceAccessor) {
        return new Configurator(registry, serviceAccessor);
    }

    public static <T> void registerService(Class<T> serviceType, IConfigRegistry configRegistry, T service) {
        configRegistry.registerConfigAttribute(ServiceConfigAttributes.get(serviceType), service);
    }

    public static <T> void registerService(Class<T> serviceType, IConfigRegistry configRegistry, T service, String targetDisplayMode) {
        configRegistry.registerConfigAttribute(ServiceConfigAttributes.get(serviceType), service, targetDisplayMode);
    }

    public static <T> void registerService(Class<T> serviceType, IConfigRegistry configRegistry, T service, String targetDisplayMode, String label) {
        configRegistry.registerConfigAttribute(ServiceConfigAttributes.get(serviceType), service, targetDisplayMode, label);
    }

    public static <T> T getService(Class<T> serviceType, IConfigRegistry config, String targetDisplayMode, String ... labels) {
        return (T)config.getConfigAttribute(ServiceConfigAttributes.get(serviceType), targetDisplayMode, labels);
    }

    public static <T> T getService(Class<T> serviceType, IConfigRegistry config, String targetDisplayMode, List<String> labels) {
        return (T)config.getConfigAttribute(ServiceConfigAttributes.get(serviceType), targetDisplayMode, labels);
    }

    public static <T> T getService(Class<T> serviceType, IConfigRegistry config, String targetDisplayMode, LabelStack labels) {
        return ServiceConfigAttributes.getService(serviceType, config, targetDisplayMode, labels.getLabels());
    }

    public static <T> T getService(Class<T> serviceType, IConfigRegistry config, ILayerCell cell) {
        return ServiceConfigAttributes.getService(serviceType, config, cell.getDisplayMode(), cell.getConfigLabels().getLabels());
    }

    public static class Configurator {
        private final IConfigRegistry configRegistry;
        private final Function<? super Class<?>, ?> serviceAccessor;

        Configurator(IConfigRegistry configRegistry, Function<? super Class<?>, ?> serviceAccessor) {
            this.configRegistry = configRegistry;
            this.serviceAccessor = serviceAccessor;
        }

        <T> T getService(Class<T> serviceType) {
            Function<Class<?>, ?> accessor = this.serviceAccessor;
            return (T)accessor.apply(serviceType);
        }

        public <T> Configurator register(Class<T> serviceType) {
            ServiceConfigAttributes.registerService(serviceType, this.configRegistry, this.getService(serviceType));
            return this;
        }

        public <T> Configurator register(Class<T> serviceType, String targetDisplayMode) {
            ServiceConfigAttributes.registerService(serviceType, this.configRegistry, this.getService(serviceType), targetDisplayMode);
            return this;
        }

        public <T> Configurator register(Class<T> serviceType, String targetDisplayMode, String label) {
            ServiceConfigAttributes.registerService(serviceType, this.configRegistry, this.getService(serviceType), targetDisplayMode, label);
            return this;
        }
    }
}

