/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.alf;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;
import org.eclipse.papyrus.uml.alf.AlfStandaloneSetup;
import org.eclipse.papyrus.uml.alf.MappingError;
import org.eclipse.papyrus.uml.alf.ModelMerge;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.resources.util.UMLResourcesUtil;

public class AlfMapper {
    public static final String QVT_PATH = "org.eclipse.papyrus.uml.alf.to.fuml/transformation/Alf2UML.qvto";
    protected TransformationExecutor executor;
    protected ExecutionContextImpl context;
    protected Injector injector;
    protected ResourceSet resourceSet;
    protected Resource resource;
    protected Profile standardProfile;
    protected Profile actionLanguageProfile;
    protected static final URI ALF_MODEL_URI = URI.createFileURI((String)"Alf_Model.tmp");

    public AlfMapper() {
        String base = CommonPlugin.getPlugin() == null ? "../" : "platform:/plugin/";
        this.executor = new TransformationExecutor(URIConverter.INSTANCE.normalize(URI.createURI((String)(String.valueOf(base) + QVT_PATH))));
        this.context = new ExecutionContextImpl();
        this.context.setConfigProperty("keepModeling", (Object)true);
        this.context.setLog((Log)new WriterLog((Writer)new OutputStreamWriter(System.err)));
        this.injector = new AlfStandaloneSetup().createInjectorAndDoEMFRegistration();
    }

    public AlfMapper(ResourceSet resourceSet) {
        this();
        this.setResourceSet(resourceSet);
    }

    public AlfMapper(Profile standardProfile, Profile actionLanguageProfile) {
        this();
        this.setStandardProfile(standardProfile);
        this.setActionLanguageProfile(actionLanguageProfile);
    }

    public AlfMapper(ResourceSet resourceSet, Profile standardProfile, Profile actionLanguageProfile) {
        this(standardProfile, actionLanguageProfile);
        this.setResourceSet(resourceSet);
    }

    public Injector getInjector() {
        return this.injector;
    }

    public void setStandardProfile(Profile profile) {
        this.standardProfile = profile;
    }

    public void setActionLanguageProfile(Profile profile) {
        this.actionLanguageProfile = profile;
    }

    public Profile getActionLanguageProfile() {
        return this.actionLanguageProfile;
    }

    public void setResourceSet(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public ResourceSet getResourceSet() {
        if (this.resourceSet == null) {
            this.resourceSet = new ResourceSetImpl();
            UMLResourcesUtil.init((ResourceSet)this.resourceSet);
        }
        return this.resourceSet;
    }

    public Resource getResource() {
        if (this.resource == null) {
            ResourceSet resourceSet = this.getResourceSet();
            this.resource = resourceSet.getResource(ALF_MODEL_URI, false);
            if (this.resource == null) {
                this.resource = resourceSet.createResource(ALF_MODEL_URI, "org.eclipse.uml2.uml_5_0_0");
            }
            this.resource.setTrackingModification(false);
            this.resource.eAdapters().clear();
        }
        return this.resource;
    }

    protected static void applyProfile(Package model, Profile profile) {
        if (profile != null) {
            model.applyProfile(profile);
        }
    }

    protected void setModel(Package model) {
        EList contents = this.getResource().getContents();
        contents.clear();
        contents.add(model);
    }

    public List<EObject> map(List<EObject> alf) throws MappingError {
        Model model = UMLFactory.eINSTANCE.createModel();
        model.setName("Model");
        AlfMapper.applyProfile((Package)model, this.standardProfile);
        AlfMapper.applyProfile((Package)model, this.actionLanguageProfile);
        this.setModel((Package)model);
        BasicModelExtent input = new BasicModelExtent(alf);
        BasicModelExtent output = new BasicModelExtent(Collections.singletonList(model));
        ExecutionDiagnostic diagnostic = this.executor.execute((ExecutionContext)this.context, new ModelExtent[]{input, output});
        if (diagnostic.getSeverity() == 0) {
            this.resource.getContents().addAll((Collection)output.getContents());
            return output.getContents();
        }
        throw new MappingError(diagnostic);
    }

    public void map(NamedElement contextElement, List<EObject> alf) throws MappingError {
        List<EObject> uml = this.map(alf);
        Package model = (Package)uml.get(0);
        Model contextModel = contextElement.getModel();
        for (Profile profile : model.getAppliedProfiles()) {
            if (contextModel.isProfileApplied(profile)) continue;
            contextModel.applyProfile(profile);
        }
        ModelMerge merge = new ModelMerge();
        BasicEList elements = new BasicEList((Collection)model.getPackagedElements());
        for (PackageableElement member : elements) {
            String name = member.getName();
            if (!(member instanceof Namespace) || name == null || name.length() >= 3 && name.substring(0, 2).equals("$$")) continue;
            merge.update((EObject)contextElement, (EObject)member);
            elements.remove(member);
            break;
        }
        merge.updateAll(contextModel.getPackagedElements(), elements);
        merge.applyReplacements((EObject)contextModel);
    }

    protected void clean() {
        if (this.resource != null) {
            try {
                this.resource.delete(null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

