/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.timing.custom.edit.parts;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gmf.runtime.diagram.ui.figures.ResizableCompartmentFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.FigureUtils;
import org.eclipse.papyrus.uml.diagram.common.Activator;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.CompactLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.figures.FullLifelineFigure;
import org.eclipse.papyrus.uml.diagram.timing.custom.layouts.FillLayout;
import org.eclipse.papyrus.uml.diagram.timing.custom.utils.ViewUtils;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.FullLifelineEditPartCN;
import org.eclipse.papyrus.uml.diagram.timing.edit.parts.InteractionCompartmentEditPartTN;

public class CustomInteractionCompartmentEditPartTN
extends InteractionCompartmentEditPartTN {
    public CustomInteractionCompartmentEditPartTN(View view) {
        super(view);
    }

    @Override
    public IFigure createFigure() {
        ResizableCompartmentFigure result = (ResizableCompartmentFigure)super.createFigure();
        result.setTitleVisibility(false);
        result.setBorder(null);
        result.setLayoutManager((LayoutManager)new FillLayout());
        result.getContentPane().setLayoutManager((LayoutManager)new AbstractLayout(){

            public void layout(IFigure container) {
                List children = container.getChildren();
                Rectangle clientArea = container.getClientArea();
                Map<IFigure, Integer> numberOfStates = CustomInteractionCompartmentEditPartTN.this.computeNumberOfStates(children);
                double totalStates = 0.0;
                for (Integer nStates : numberOfStates.values()) {
                    totalStates += (double)Math.max(nStates, 1);
                }
                int y = clientArea.y;
                int totalHeight = clientArea.height - 8 * (children.size() - 1);
                for (IFigure child : children) {
                    Integer nStates = numberOfStates.get(child);
                    if (nStates == null) continue;
                    int height = (int)((double)totalHeight * (Math.max(nStates.doubleValue(), 1.0) / totalStates));
                    child.setBounds(new Rectangle(clientArea.x, y, clientArea.width, height));
                    y += height + 8;
                }
            }

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                return new Dimension(-1, -1);
            }
        });
        return result;
    }

    protected Map<IFigure, Integer> computeNumberOfStates(List<IFigure> children) {
        LinkedHashMap<IFigure, Integer> numberOfStatesPerLifeline = new LinkedHashMap<IFigure, Integer>();
        EditPartViewer viewer = this.getRoot().getViewer();
        int i = 0;
        while (i < children.size()) {
            IFigure child = children.get(i);
            if (FigureUtils.findChildFigureInstance((IFigure)child, FullLifelineFigure.class) != null) {
                Map visualPartMap = viewer.getVisualPartMap();
                FullLifelineEditPartCN lifelineEditPart = (FullLifelineEditPartCN)((Object)visualPartMap.get(child));
                View lifelineView = (View)lifelineEditPart.getModel();
                int nStates = CustomInteractionCompartmentEditPartTN.findNumberOfStatesDisplayedIn(lifelineView);
                numberOfStatesPerLifeline.put(child, nStates);
            } else if (FigureUtils.findChildFigureInstance((IFigure)child, CompactLifelineFigure.class) != null) {
                numberOfStatesPerLifeline.put(child, 1);
            } else {
                Activator.log.warn("Only instances of " + FullLifelineFigure.class.getSimpleName() + " are expected in the compartment " + CustomInteractionCompartmentEditPartTN.class.getSimpleName());
            }
            ++i;
        }
        return numberOfStatesPerLifeline;
    }

    protected static int findNumberOfStatesDisplayedIn(View lifelineView) {
        int n = 0;
        View stateDefinitionCompartment = ViewUtils.findStateDefinitionCompartmentView(lifelineView);
        EList children = stateDefinitionCompartment.getChildren();
        String stateDefID = "Node_StateDefinitionShape";
        for (View view : children) {
            if (!"Node_StateDefinitionShape".equals(view.getType())) continue;
            ++n;
        }
        return n;
    }

    public boolean isSelectable() {
        return false;
    }
}

